/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.statistics.BinaryStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.BooleanStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.CountStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.DoubleStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.IntegerStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.StatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.StatisticsBuilders;
import com.facebook.presto.orc.metadata.statistics.StringStatisticsBuilder;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStatisticsBuilders {
    @Test
    public void testCreateStatisticsBuilder() {
        Assert.assertTrue((boolean)(TestStatisticsBuilders.createStatisticsBuilder((Type)TinyintType.TINYINT) instanceof CountStatisticsBuilder));
        Assert.assertTrue((boolean)(TestStatisticsBuilders.createStatisticsBuilder((Type)SmallintType.SMALLINT) instanceof IntegerStatisticsBuilder));
        Assert.assertTrue((boolean)(TestStatisticsBuilders.createStatisticsBuilder((Type)IntegerType.INTEGER) instanceof IntegerStatisticsBuilder));
        Assert.assertTrue((boolean)(TestStatisticsBuilders.createStatisticsBuilder((Type)BigintType.BIGINT) instanceof IntegerStatisticsBuilder));
        Assert.assertTrue((boolean)(TestStatisticsBuilders.createStatisticsBuilder((Type)VarcharType.VARCHAR) instanceof StringStatisticsBuilder));
        Assert.assertTrue((boolean)(TestStatisticsBuilders.createStatisticsBuilder((Type)VarbinaryType.VARBINARY) instanceof BinaryStatisticsBuilder));
        Assert.assertTrue((boolean)(TestStatisticsBuilders.createStatisticsBuilder((Type)BooleanType.BOOLEAN) instanceof BooleanStatisticsBuilder));
        Assert.assertTrue((boolean)(TestStatisticsBuilders.createStatisticsBuilder((Type)RealType.REAL) instanceof DoubleStatisticsBuilder));
        Assert.assertTrue((boolean)(TestStatisticsBuilders.createStatisticsBuilder((Type)DoubleType.DOUBLE) instanceof DoubleStatisticsBuilder));
        Assert.assertTrue((boolean)(TestStatisticsBuilders.createStatisticsBuilder((Type)TimestampType.TIMESTAMP) instanceof CountStatisticsBuilder));
        Assert.assertTrue((boolean)(TestStatisticsBuilders.createStatisticsBuilder((Type)TimestampType.TIMESTAMP_MICROSECONDS) instanceof CountStatisticsBuilder));
        Assert.assertTrue((boolean)(TestStatisticsBuilders.createStatisticsBuilder(OrcTester.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)) instanceof CountStatisticsBuilder));
        Assert.assertTrue((boolean)(TestStatisticsBuilders.createStatisticsBuilder(OrcTester.arrayType((Type)IntegerType.INTEGER)) instanceof CountStatisticsBuilder));
        Assert.assertTrue((boolean)(TestStatisticsBuilders.createStatisticsBuilder(OrcTester.rowType(new Type[]{IntegerType.INTEGER})) instanceof CountStatisticsBuilder));
    }

    @Test
    public void testCreateStatisticsBuilderInvalidType() {
        Assert.assertThrows(IllegalArgumentException.class, () -> TestStatisticsBuilders.createStatisticsBuilder((Type)DateType.DATE));
    }

    @Test
    public void testCreateEmptyColumnStatistics() {
        ColumnWriterOptions columnWriterOptions = ColumnWriterOptions.builder().setCompressionKind(CompressionKind.ZSTD).build();
        Type rootType = OrcTester.rowType(new Type[]{TinyintType.TINYINT, OrcTester.mapType((Type)TinyintType.TINYINT, (Type)SmallintType.SMALLINT), RealType.REAL, OrcTester.mapType((Type)IntegerType.INTEGER, OrcTester.arrayType((Type)BigintType.BIGINT)), DoubleType.DOUBLE, OrcTester.arrayType((Type)VarcharType.VARCHAR), TimestampType.TIMESTAMP, OrcTester.rowType(new Type[]{VarbinaryType.VARBINARY, OrcTester.rowType(new Type[]{BooleanType.BOOLEAN})})});
        List orcTypes = OrcType.toOrcType((int)0, (Type)rootType);
        Map columnStatistics = StatisticsBuilders.createEmptyColumnStatistics((List)orcTypes, (int)0, (ColumnWriterOptions)columnWriterOptions);
        Assert.assertEquals((int)columnStatistics.size(), (int)18);
        for (int i = 0; i < 18; ++i) {
            ColumnStatistics emptyColumnStatistics = (ColumnStatistics)columnStatistics.get(i);
            Assert.assertNotNull((Object)emptyColumnStatistics);
            Assert.assertEquals((long)emptyColumnStatistics.getNumberOfValues(), (long)0L);
        }
    }

    private static StatisticsBuilder createStatisticsBuilder(Type type) {
        ColumnWriterOptions columnWriterOptions = ColumnWriterOptions.builder().setCompressionKind(CompressionKind.ZSTD).build();
        OrcType orcType = (OrcType)OrcType.toOrcType((int)0, (Type)type).get(0);
        Supplier supplier = StatisticsBuilders.createStatisticsBuilderSupplier((OrcType)orcType, (ColumnWriterOptions)columnWriterOptions);
        return (StatisticsBuilder)supplier.get();
    }
}

