/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.AbstractRangeStatisticsTest;
import com.facebook.presto.orc.metadata.statistics.StringStatistics;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import org.openjdk.jol.info.ClassLayout;
import org.testng.annotations.Test;

public class TestStringStatistics
extends AbstractRangeStatisticsTest<StringStatistics, Slice> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(StringStatistics.class).instanceSize();
    private static final Slice LOW_BOTTOM_VALUE = Slices.utf8Slice((String)"foo \u0000");
    private static final Slice LOW_TOP_VALUE = Slices.utf8Slice((String)"foo \ud7ff");
    private static final Slice MEDIUM_BOTTOM_VALUE = Slices.utf8Slice((String)"foo \ue000");
    private static final Slice MEDIUM_TOP_VALUE = Slices.utf8Slice((String)"foo \uffff");
    private static final Slice HIGH_BOTTOM_VALUE = Slices.utf8Slice((String)"foo \ud800\udc00");
    private static final Slice HIGH_TOP_VALUE = Slices.utf8Slice((String)"foo \udbff\udfff");

    @Override
    protected StringStatistics getCreateStatistics(Slice min, Slice max) {
        return new StringStatistics(min, max, 100L);
    }

    @Test
    public void test() {
        this.assertMinMax(Slices.EMPTY_SLICE, LOW_BOTTOM_VALUE);
        this.assertMinMax(Slices.EMPTY_SLICE, LOW_TOP_VALUE);
        this.assertMinMax(Slices.EMPTY_SLICE, MEDIUM_BOTTOM_VALUE);
        this.assertMinMax(Slices.EMPTY_SLICE, MEDIUM_TOP_VALUE);
        this.assertMinMax(Slices.EMPTY_SLICE, HIGH_BOTTOM_VALUE);
        this.assertMinMax(Slices.EMPTY_SLICE, HIGH_TOP_VALUE);
        this.assertMinMax(LOW_BOTTOM_VALUE, LOW_TOP_VALUE);
        this.assertMinMax(LOW_BOTTOM_VALUE, MEDIUM_BOTTOM_VALUE);
        this.assertMinMax(LOW_BOTTOM_VALUE, MEDIUM_TOP_VALUE);
        this.assertMinMax(LOW_BOTTOM_VALUE, HIGH_BOTTOM_VALUE);
        this.assertMinMax(LOW_BOTTOM_VALUE, HIGH_TOP_VALUE);
        this.assertMinMax(LOW_TOP_VALUE, MEDIUM_BOTTOM_VALUE);
        this.assertMinMax(LOW_TOP_VALUE, MEDIUM_TOP_VALUE);
        this.assertMinMax(LOW_TOP_VALUE, HIGH_BOTTOM_VALUE);
        this.assertMinMax(LOW_TOP_VALUE, HIGH_TOP_VALUE);
        this.assertMinMax(MEDIUM_BOTTOM_VALUE, MEDIUM_TOP_VALUE);
        this.assertMinMax(MEDIUM_BOTTOM_VALUE, HIGH_BOTTOM_VALUE);
        this.assertMinMax(MEDIUM_BOTTOM_VALUE, HIGH_TOP_VALUE);
        this.assertMinMax(MEDIUM_TOP_VALUE, HIGH_BOTTOM_VALUE);
        this.assertMinMax(MEDIUM_TOP_VALUE, HIGH_TOP_VALUE);
        this.assertMinMax(HIGH_BOTTOM_VALUE, HIGH_TOP_VALUE);
    }

    @Test
    public void testRetainedSize() {
        this.assertRetainedSize(Slices.EMPTY_SLICE, LOW_BOTTOM_VALUE, (long)INSTANCE_SIZE + Slices.EMPTY_SLICE.getRetainedSize() + LOW_BOTTOM_VALUE.getRetainedSize());
        this.assertRetainedSize(LOW_TOP_VALUE, LOW_TOP_VALUE, (long)INSTANCE_SIZE + LOW_TOP_VALUE.getRetainedSize());
        this.assertRetainedSize(Slices.EMPTY_SLICE, Slices.EMPTY_SLICE, (long)INSTANCE_SIZE + Slices.EMPTY_SLICE.getRetainedSize());
        this.assertRetainedSize(MEDIUM_TOP_VALUE, HIGH_BOTTOM_VALUE, (long)INSTANCE_SIZE + MEDIUM_TOP_VALUE.getRetainedSize() + HIGH_BOTTOM_VALUE.getRetainedSize());
        this.assertRetainedSize(null, HIGH_BOTTOM_VALUE, (long)INSTANCE_SIZE + HIGH_BOTTOM_VALUE.getRetainedSize());
        this.assertRetainedSize(Slices.EMPTY_SLICE, null, (long)INSTANCE_SIZE + Slices.EMPTY_SLICE.getRetainedSize());
        this.assertRetainedSize(null, null, INSTANCE_SIZE);
    }
}

