/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.VariableWidthBlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.metadata.statistics.AbstractStatisticsBuilderTest;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.StringColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.StringStatistics;
import com.facebook.presto.orc.metadata.statistics.StringStatisticsBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStringStatisticsBuilder
extends AbstractStatisticsBuilderTest<StringStatisticsBuilder, Slice> {
    private static final Slice LOW_BOTTOM_VALUE = Slices.utf8Slice((String)"foo \u0000");
    private static final Slice LOW_TOP_VALUE = Slices.utf8Slice((String)"foo \ud7ff");
    private static final Slice MEDIUM_BOTTOM_VALUE = Slices.utf8Slice((String)"foo \ue000");
    private static final Slice MEDIUM_TOP_VALUE = Slices.utf8Slice((String)"foo \uffff");
    private static final Slice HIGH_BOTTOM_VALUE = Slices.utf8Slice((String)"foo \ud800\udc00");
    private static final Slice HIGH_TOP_VALUE = Slices.utf8Slice((String)"foo \udbff\udfff");
    private static final Slice LONG_BOTTOM_VALUE = Slices.utf8Slice((String)"aaaaaaaaaaaaaaaaaaaa");

    public TestStringStatisticsBuilder() {
        super(AbstractStatisticsBuilderTest.StatisticsType.STRING, () -> new StringStatisticsBuilder(Integer.MAX_VALUE), TestStringStatisticsBuilder::addValue);
    }

    @Test
    public void testMinMaxValues() {
        this.assertMinMaxValues(Slices.EMPTY_SLICE, Slices.EMPTY_SLICE);
        this.assertMinMaxValues(LOW_BOTTOM_VALUE, LOW_BOTTOM_VALUE);
        this.assertMinMaxValues(LOW_TOP_VALUE, LOW_TOP_VALUE);
        this.assertMinMaxValues(MEDIUM_BOTTOM_VALUE, MEDIUM_BOTTOM_VALUE);
        this.assertMinMaxValues(MEDIUM_TOP_VALUE, MEDIUM_TOP_VALUE);
        this.assertMinMaxValues(HIGH_BOTTOM_VALUE, HIGH_BOTTOM_VALUE);
        this.assertMinMaxValues(HIGH_TOP_VALUE, HIGH_TOP_VALUE);
        this.assertMinMaxValues(Slices.EMPTY_SLICE, LOW_BOTTOM_VALUE);
        this.assertMinMaxValues(Slices.EMPTY_SLICE, LOW_TOP_VALUE);
        this.assertMinMaxValues(Slices.EMPTY_SLICE, MEDIUM_BOTTOM_VALUE);
        this.assertMinMaxValues(Slices.EMPTY_SLICE, MEDIUM_TOP_VALUE);
        this.assertMinMaxValues(Slices.EMPTY_SLICE, HIGH_BOTTOM_VALUE);
        this.assertMinMaxValues(Slices.EMPTY_SLICE, HIGH_TOP_VALUE);
        this.assertMinMaxValues(LOW_BOTTOM_VALUE, LOW_TOP_VALUE);
        this.assertMinMaxValues(LOW_BOTTOM_VALUE, MEDIUM_BOTTOM_VALUE);
        this.assertMinMaxValues(LOW_BOTTOM_VALUE, MEDIUM_TOP_VALUE);
        this.assertMinMaxValues(LOW_BOTTOM_VALUE, HIGH_BOTTOM_VALUE);
        this.assertMinMaxValues(LOW_BOTTOM_VALUE, HIGH_TOP_VALUE);
        this.assertMinMaxValues(LOW_TOP_VALUE, MEDIUM_BOTTOM_VALUE);
        this.assertMinMaxValues(LOW_TOP_VALUE, MEDIUM_TOP_VALUE);
        this.assertMinMaxValues(LOW_TOP_VALUE, HIGH_BOTTOM_VALUE);
        this.assertMinMaxValues(LOW_TOP_VALUE, HIGH_TOP_VALUE);
        this.assertMinMaxValues(MEDIUM_BOTTOM_VALUE, MEDIUM_TOP_VALUE);
        this.assertMinMaxValues(MEDIUM_BOTTOM_VALUE, HIGH_BOTTOM_VALUE);
        this.assertMinMaxValues(MEDIUM_BOTTOM_VALUE, HIGH_TOP_VALUE);
        this.assertMinMaxValues(MEDIUM_TOP_VALUE, HIGH_BOTTOM_VALUE);
        this.assertMinMaxValues(MEDIUM_TOP_VALUE, HIGH_TOP_VALUE);
        this.assertMinMaxValues(HIGH_BOTTOM_VALUE, HIGH_TOP_VALUE);
    }

    @Test
    public void testSum() {
        StringStatisticsBuilder stringStatisticsBuilder = new StringStatisticsBuilder(Integer.MAX_VALUE);
        for (Slice value : ImmutableList.of((Object)Slices.EMPTY_SLICE, (Object)LOW_BOTTOM_VALUE, (Object)LOW_TOP_VALUE)) {
            TestStringStatisticsBuilder.addValue(stringStatisticsBuilder, value);
        }
        this.assertStringStatistics(stringStatisticsBuilder.buildColumnStatistics(), 3, Slices.EMPTY_SLICE.length() + LOW_BOTTOM_VALUE.length() + LOW_TOP_VALUE.length());
    }

    @Test
    public void testMerge() {
        ArrayList<ColumnStatistics> statisticsList = new ArrayList<ColumnStatistics>();
        StringStatisticsBuilder statisticsBuilder = new StringStatisticsBuilder(Integer.MAX_VALUE);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        this.assertMergedStringStatistics(statisticsList, 0, 0);
        TestStringStatisticsBuilder.addValue(statisticsBuilder, Slices.EMPTY_SLICE);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        this.assertMergedStringStatistics(statisticsList, 1, 0);
        TestStringStatisticsBuilder.addValue(statisticsBuilder, LOW_BOTTOM_VALUE);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        this.assertMergedStringStatistics(statisticsList, 3, LOW_BOTTOM_VALUE.length());
        TestStringStatisticsBuilder.addValue(statisticsBuilder, LOW_TOP_VALUE);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        this.assertMergedStringStatistics(statisticsList, 6, LOW_BOTTOM_VALUE.length() * 2 + LOW_TOP_VALUE.length());
    }

    @Test
    public void testMinMaxValuesWithLimit() {
        TestStringStatisticsBuilder.assertMinMaxValuesWithLimit(MEDIUM_TOP_VALUE, null, (List<Slice>)ImmutableList.of((Object)MEDIUM_TOP_VALUE, (Object)HIGH_BOTTOM_VALUE), 7);
        TestStringStatisticsBuilder.assertMinMaxValuesWithLimit(null, MEDIUM_TOP_VALUE, (List<Slice>)ImmutableList.of((Object)LONG_BOTTOM_VALUE, (Object)MEDIUM_TOP_VALUE), 7);
        TestStringStatisticsBuilder.assertMinMaxValuesWithLimit(null, null, (List<Slice>)ImmutableList.of((Object)LONG_BOTTOM_VALUE), 6, 20L);
    }

    @Test
    public void testMergeWithLimit() {
        ArrayList<ColumnStatistics> statisticsList = new ArrayList<ColumnStatistics>();
        statisticsList.add(TestStringStatisticsBuilder.stringColumnStatistics(MEDIUM_BOTTOM_VALUE, MEDIUM_BOTTOM_VALUE));
        TestStringStatisticsBuilder.assertMinMax(ColumnStatistics.mergeColumnStatistics(statisticsList).getStringStatistics(), MEDIUM_BOTTOM_VALUE, MEDIUM_BOTTOM_VALUE);
        statisticsList.add(TestStringStatisticsBuilder.stringColumnStatistics(null, MEDIUM_BOTTOM_VALUE));
        TestStringStatisticsBuilder.assertMinMax(ColumnStatistics.mergeColumnStatistics(statisticsList).getStringStatistics(), null, MEDIUM_BOTTOM_VALUE);
        statisticsList.add(TestStringStatisticsBuilder.stringColumnStatistics(null, MEDIUM_TOP_VALUE));
        TestStringStatisticsBuilder.assertMinMax(ColumnStatistics.mergeColumnStatistics(statisticsList).getStringStatistics(), null, MEDIUM_TOP_VALUE);
        statisticsList.add(TestStringStatisticsBuilder.stringColumnStatistics(MEDIUM_TOP_VALUE, null));
        TestStringStatisticsBuilder.assertMinMax(ColumnStatistics.mergeColumnStatistics(statisticsList).getStringStatistics(), null, null, 400L);
        statisticsList.add(TestStringStatisticsBuilder.stringColumnStatistics(MEDIUM_BOTTOM_VALUE, MEDIUM_BOTTOM_VALUE));
        TestStringStatisticsBuilder.assertMinMax(ColumnStatistics.mergeColumnStatistics(statisticsList).getStringStatistics(), null, null, 500L);
    }

    @Test
    public void testMergeWithNullMinMaxValues() {
        ArrayList<ColumnStatistics> statisticsList = new ArrayList<ColumnStatistics>();
        statisticsList.add(TestStringStatisticsBuilder.stringColumnStatistics(MEDIUM_BOTTOM_VALUE, MEDIUM_BOTTOM_VALUE));
        TestStringStatisticsBuilder.assertMinMax(ColumnStatistics.mergeColumnStatistics(statisticsList).getStringStatistics(), MEDIUM_BOTTOM_VALUE, MEDIUM_BOTTOM_VALUE);
        statisticsList.add(TestStringStatisticsBuilder.stringColumnStatistics(null, null));
        TestStringStatisticsBuilder.assertMinMax(ColumnStatistics.mergeColumnStatistics(statisticsList).getStringStatistics(), null, null);
    }

    @Test
    public void testMixingAddValueAndMergeWithLimit() {
        ArrayList<Object> statisticsList = new ArrayList<ColumnStatistics>();
        StringStatisticsBuilder statisticsBuilder = new StringStatisticsBuilder(7);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        this.assertMergedStringStatistics(statisticsList, 0, 0);
        TestStringStatisticsBuilder.addValue(statisticsBuilder, LOW_BOTTOM_VALUE);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        this.assertMergedStringStatistics(statisticsList, 1, LOW_BOTTOM_VALUE.length());
        TestStringStatisticsBuilder.assertMinMax(ColumnStatistics.mergeColumnStatistics(statisticsList).getStringStatistics(), LOW_BOTTOM_VALUE, LOW_BOTTOM_VALUE);
        TestStringStatisticsBuilder.addValue(statisticsBuilder, LOW_TOP_VALUE);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        this.assertMergedStringStatistics(statisticsList, 3, LOW_BOTTOM_VALUE.length() * 2 + LOW_TOP_VALUE.length());
        TestStringStatisticsBuilder.assertMinMax(ColumnStatistics.mergeColumnStatistics(statisticsList).getStringStatistics(), LOW_BOTTOM_VALUE, LOW_TOP_VALUE);
        TestStringStatisticsBuilder.addValue(statisticsBuilder, HIGH_BOTTOM_VALUE);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        this.assertMergedStringStatistics(statisticsList, 6, LOW_BOTTOM_VALUE.length() * 3 + LOW_TOP_VALUE.length() * 2 + HIGH_BOTTOM_VALUE.length());
        TestStringStatisticsBuilder.assertMinMax(ColumnStatistics.mergeColumnStatistics(statisticsList).getStringStatistics(), LOW_BOTTOM_VALUE, null);
        TestStringStatisticsBuilder.addValue(statisticsBuilder, HIGH_BOTTOM_VALUE);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        this.assertMergedStringStatistics(statisticsList, 10, LOW_BOTTOM_VALUE.length() * 4 + LOW_TOP_VALUE.length() * 3 + HIGH_BOTTOM_VALUE.length() * 3);
        TestStringStatisticsBuilder.assertMinMax(ColumnStatistics.mergeColumnStatistics(statisticsList).getStringStatistics(), LOW_BOTTOM_VALUE, null);
        statisticsList = new ArrayList();
        statisticsBuilder = new StringStatisticsBuilder(7);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        this.assertMergedStringStatistics(statisticsList, 0, 0);
        TestStringStatisticsBuilder.addValue(statisticsBuilder, MEDIUM_TOP_VALUE);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        this.assertMergedStringStatistics(statisticsList, 1, MEDIUM_TOP_VALUE.length());
        TestStringStatisticsBuilder.assertMinMax(ColumnStatistics.mergeColumnStatistics(statisticsList).getStringStatistics(), MEDIUM_TOP_VALUE, MEDIUM_TOP_VALUE);
        TestStringStatisticsBuilder.addValue(statisticsBuilder, MEDIUM_BOTTOM_VALUE);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        this.assertMergedStringStatistics(statisticsList, 3, MEDIUM_TOP_VALUE.length() * 2 + MEDIUM_BOTTOM_VALUE.length());
        TestStringStatisticsBuilder.assertMinMax(ColumnStatistics.mergeColumnStatistics(statisticsList).getStringStatistics(), MEDIUM_BOTTOM_VALUE, MEDIUM_TOP_VALUE);
        TestStringStatisticsBuilder.addValue(statisticsBuilder, LONG_BOTTOM_VALUE);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        this.assertMergedStringStatistics(statisticsList, 6, MEDIUM_TOP_VALUE.length() * 3 + MEDIUM_BOTTOM_VALUE.length() * 2 + LONG_BOTTOM_VALUE.length());
        TestStringStatisticsBuilder.assertMinMax(ColumnStatistics.mergeColumnStatistics(statisticsList).getStringStatistics(), null, MEDIUM_TOP_VALUE);
        TestStringStatisticsBuilder.addValue(statisticsBuilder, LONG_BOTTOM_VALUE);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        this.assertMergedStringStatistics(statisticsList, 10, MEDIUM_TOP_VALUE.length() * 4 + MEDIUM_BOTTOM_VALUE.length() * 3 + LONG_BOTTOM_VALUE.length() * 3);
        TestStringStatisticsBuilder.assertMinMax(ColumnStatistics.mergeColumnStatistics(statisticsList).getStringStatistics(), null, MEDIUM_TOP_VALUE);
        statisticsList = new ArrayList();
        statisticsBuilder = new StringStatisticsBuilder(7);
        TestStringStatisticsBuilder.addValue(statisticsBuilder, MEDIUM_BOTTOM_VALUE);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        TestStringStatisticsBuilder.assertMinMax(ColumnStatistics.mergeColumnStatistics(statisticsList).getStringStatistics(), MEDIUM_BOTTOM_VALUE, MEDIUM_BOTTOM_VALUE);
        TestStringStatisticsBuilder.addValue(statisticsBuilder, LONG_BOTTOM_VALUE);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        TestStringStatisticsBuilder.assertMinMax(ColumnStatistics.mergeColumnStatistics(statisticsList).getStringStatistics(), null, MEDIUM_BOTTOM_VALUE);
        TestStringStatisticsBuilder.addValue(statisticsBuilder, HIGH_TOP_VALUE);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        TestStringStatisticsBuilder.assertMinMax(ColumnStatistics.mergeColumnStatistics(statisticsList).getStringStatistics(), null, null);
        TestStringStatisticsBuilder.addValue(statisticsBuilder, HIGH_BOTTOM_VALUE);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        TestStringStatisticsBuilder.assertMinMax(ColumnStatistics.mergeColumnStatistics(statisticsList).getStringStatistics(), null, null);
    }

    @Test
    public void testCopyStatsToSaveMemory() {
        StringStatisticsBuilder statisticsBuilder = new StringStatisticsBuilder(Integer.MAX_VALUE);
        Slice shortSlice = Slices.wrappedBuffer((byte[])LONG_BOTTOM_VALUE.getBytes(), (int)0, (int)1);
        TestStringStatisticsBuilder.addValue(statisticsBuilder, shortSlice);
        Slice stats = statisticsBuilder.buildColumnStatistics().getStringStatistics().getMax();
        Assert.assertNotNull((Object)stats);
        Assert.assertEquals((long)stats.getRetainedSize(), (long)Slices.wrappedBuffer((byte[])new byte[1]).getRetainedSize());
    }

    @Test
    public void testTotalValueBytes() {
        this.assertTotalValueBytes(0L, ImmutableList.of());
        this.assertTotalValueBytes(5L, ImmutableList.of((Object)Slices.EMPTY_SLICE));
        this.assertTotalValueBytes((long)LOW_BOTTOM_VALUE.length() + 5L, ImmutableList.of((Object)LOW_BOTTOM_VALUE));
        this.assertTotalValueBytes((long)(LOW_BOTTOM_VALUE.length() + LOW_TOP_VALUE.length()) + 10L, ImmutableList.of((Object)LOW_BOTTOM_VALUE, (Object)LOW_TOP_VALUE));
    }

    @Test
    public void testBlockStringStatistics() {
        String alphabets = "abcdefghijklmnopqrstuvwxyz";
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, alphabets.length(), alphabets.length());
        Slice slice = Slices.utf8Slice((String)alphabets);
        for (int i = 0; i < slice.length(); ++i) {
            VarcharType.VARCHAR.writeSlice((BlockBuilder)blockBuilder, slice, i, 1);
        }
        blockBuilder.appendNull();
        StringStatisticsBuilder stringStatisticsBuilder = new StringStatisticsBuilder(1000);
        stringStatisticsBuilder.addBlock((Type)VarcharType.VARCHAR, (Block)blockBuilder);
        StringStatistics stringStatistics = stringStatisticsBuilder.buildColumnStatistics().getStringStatistics();
        Assert.assertEquals((Object)stringStatistics.getMin(), (Object)slice.slice(0, 1));
        Assert.assertEquals((Object)stringStatistics.getMax(), (Object)slice.slice(slice.length() - 1, 1));
        Assert.assertEquals((long)stringStatistics.getSum(), (long)slice.length());
    }

    @Test
    public void testAddValueByPosition() {
        String alphabet = "abcdefghijklmnopqrstuvwxyz";
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, alphabet.length(), alphabet.length());
        Slice slice = Slices.utf8Slice((String)alphabet);
        for (int i = 0; i < slice.length(); ++i) {
            VarcharType.VARCHAR.writeSlice((BlockBuilder)blockBuilder, slice, i, 1);
        }
        blockBuilder.appendNull();
        StringStatisticsBuilder stringStatisticsBuilder = new StringStatisticsBuilder(1000);
        int positionCount = blockBuilder.getPositionCount();
        for (int position = 0; position < positionCount; ++position) {
            stringStatisticsBuilder.addValue((Type)VarcharType.VARCHAR, (Block)blockBuilder, position);
        }
        ColumnStatistics columnStatistics = stringStatisticsBuilder.buildColumnStatistics();
        Assert.assertEquals((long)columnStatistics.getNumberOfValues(), (long)(positionCount - 1));
        StringStatistics stringStatistics = columnStatistics.getStringStatistics();
        Assert.assertEquals((Object)stringStatistics.getMin(), (Object)slice.slice(0, 1));
        Assert.assertEquals((Object)stringStatistics.getMax(), (Object)slice.slice(slice.length() - 1, 1));
        Assert.assertEquals((long)stringStatistics.getSum(), (long)slice.length());
    }

    private void assertMergedStringStatistics(List<ColumnStatistics> statisticsList, int expectedNumberOfValues, int expectedSum) {
        this.assertStringStatistics(ColumnStatistics.mergeColumnStatistics(statisticsList), expectedNumberOfValues, expectedSum);
        TestStringStatisticsBuilder.assertNoColumnStatistics(ColumnStatistics.mergeColumnStatistics(TestStringStatisticsBuilder.insertEmptyColumnStatisticsAt(statisticsList, 0, 10L)), expectedNumberOfValues + 10);
        TestStringStatisticsBuilder.assertNoColumnStatistics(ColumnStatistics.mergeColumnStatistics(TestStringStatisticsBuilder.insertEmptyColumnStatisticsAt(statisticsList, statisticsList.size(), 10L)), expectedNumberOfValues + 10);
        TestStringStatisticsBuilder.assertNoColumnStatistics(ColumnStatistics.mergeColumnStatistics(TestStringStatisticsBuilder.insertEmptyColumnStatisticsAt(statisticsList, statisticsList.size() / 2, 10L)), expectedNumberOfValues + 10);
    }

    private static void assertMinMaxValuesWithLimit(Slice expectedMin, Slice expectedMax, List<Slice> values, int limit) {
        Preconditions.checkArgument((values != null && values.size() > 0 ? 1 : 0) != 0);
        StringStatisticsBuilder builder = new StringStatisticsBuilder(limit);
        for (Slice value : values) {
            TestStringStatisticsBuilder.addValue(builder, value);
        }
        TestStringStatisticsBuilder.assertMinMax(builder.buildColumnStatistics().getStringStatistics(), expectedMin, expectedMax);
    }

    private static void assertMinMaxValuesWithLimit(Slice expectedMin, Slice expectedMax, List<Slice> values, int limit, long expectedSum) {
        Preconditions.checkArgument((values != null && values.size() > 0 ? 1 : 0) != 0);
        StringStatisticsBuilder builder = new StringStatisticsBuilder(limit);
        for (Slice value : values) {
            TestStringStatisticsBuilder.addValue(builder, value);
        }
        TestStringStatisticsBuilder.assertMinMax(builder.buildColumnStatistics().getStringStatistics(), expectedMin, expectedMax, expectedSum);
    }

    private static void assertMinMax(StringStatistics actualStringStatistics, Slice expectedMin, Slice expectedMax) {
        if (expectedMax == null && expectedMin == null) {
            Assert.assertNull((Object)actualStringStatistics);
            return;
        }
        Assert.assertNotNull((Object)actualStringStatistics);
        Assert.assertEquals((Object)actualStringStatistics.getMin(), (Object)expectedMin);
        Assert.assertEquals((Object)actualStringStatistics.getMax(), (Object)expectedMax);
    }

    private static void assertMinMax(StringStatistics actualStringStatistics, Slice expectedMin, Slice expectedMax, long expectedSum) {
        Assert.assertNotNull((Object)actualStringStatistics);
        Assert.assertEquals((Object)actualStringStatistics.getMin(), (Object)expectedMin);
        Assert.assertEquals((Object)actualStringStatistics.getMax(), (Object)expectedMax);
        Assert.assertEquals((long)actualStringStatistics.getSum(), (long)expectedSum);
    }

    private static ColumnStatistics stringColumnStatistics(Slice minimum, Slice maximum) {
        if (minimum == null && maximum == null) {
            return new ColumnStatistics(Long.valueOf(100L), null);
        }
        return new StringColumnStatistics(Long.valueOf(100L), null, new StringStatistics(minimum, maximum, 100L));
    }

    private void assertStringStatistics(ColumnStatistics columnStatistics, int expectedNumberOfValues, long expectedSum) {
        if (expectedNumberOfValues > 0) {
            Assert.assertEquals((long)columnStatistics.getNumberOfValues(), (long)expectedNumberOfValues);
            Assert.assertEquals((long)columnStatistics.getStringStatistics().getSum(), (long)expectedSum);
        } else {
            Assert.assertNull((Object)columnStatistics.getStringStatistics());
            Assert.assertEquals((long)columnStatistics.getNumberOfValues(), (long)0L);
        }
    }

    public static void addValue(StringStatisticsBuilder stringStatisticsBuilder, Slice slice) {
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, 1, slice.length());
        blockBuilder.writeBytes(slice, 0, slice.length()).closeEntry();
        stringStatisticsBuilder.addBlock((Type)VarcharType.VARCHAR, (Block)blockBuilder);
    }
}

