/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.DecodeTimestampOptions;
import com.facebook.presto.orc.reader.ApacheHiveTimestampDecoder;
import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestApacheHiveTimestampDecoder {
    @Test
    public void testMicroseconds() {
        TestApacheHiveTimestampDecoder.test(694310400L, 7994L, true, TestApacheHiveTimestampDecoder.parseTimestamp("2037-01-01T00:00:00", 999));
        TestApacheHiveTimestampDecoder.test(-378691200L, 1776L, true, TestApacheHiveTimestampDecoder.parseTimestamp("2003-01-01T00:00:00", 0));
        TestApacheHiveTimestampDecoder.test(-504921600L, 7999999992L, true, TestApacheHiveTimestampDecoder.parseTimestamp("1999-01-01T00:00:00", 999999));
        TestApacheHiveTimestampDecoder.test(-631152000L, 5511111104L, true, TestApacheHiveTimestampDecoder.parseTimestamp("1995-01-01T00:00:00", 688888));
        TestApacheHiveTimestampDecoder.test(-410227200L, 15L, true, TestApacheHiveTimestampDecoder.parseTimestamp("2002-01-01T00:00:00", 100000));
        TestApacheHiveTimestampDecoder.test(-152582400L, 72008L, true, TestApacheHiveTimestampDecoder.parseTimestamp("2010-03-02T00:00:00", 9));
        TestApacheHiveTimestampDecoder.test(-315532800L, 17832L, true, TestApacheHiveTimestampDecoder.parseTimestamp("2005-01-01T00:00:00", 2));
        TestApacheHiveTimestampDecoder.test(-283996800L, 7201624024L, true, TestApacheHiveTimestampDecoder.parseTimestamp("2006-01-01T00:00:00", 900203));
        TestApacheHiveTimestampDecoder.test(-378691200L, 6400000056L, true, TestApacheHiveTimestampDecoder.parseTimestamp("2003-01-01T00:00:00", 800000));
        TestApacheHiveTimestampDecoder.test(-581130000L, 5784806472L, true, TestApacheHiveTimestampDecoder.parseTimestamp("1996-08-01T23:00:00", 723100));
        TestApacheHiveTimestampDecoder.test(-510105600L, 6858725144L, true, TestApacheHiveTimestampDecoder.parseTimestamp("1998-11-02T00:00:00", 857340));
        TestApacheHiveTimestampDecoder.test(-197168400L, 0L, true, TestApacheHiveTimestampDecoder.parseTimestamp("2008-10-01T23:00:00", 0));
    }

    @Test
    public void testMilliseconds() {
        TestApacheHiveTimestampDecoder.test(694310400L, 7994L, false, TestApacheHiveTimestampDecoder.parseTimestamp("2037-01-01T00:00:00", 0));
        TestApacheHiveTimestampDecoder.test(-378691200L, 1776L, false, TestApacheHiveTimestampDecoder.parseTimestamp("2003-01-01T00:00:00", 0));
        TestApacheHiveTimestampDecoder.test(-504921600L, 7999999992L, false, TestApacheHiveTimestampDecoder.parseTimestamp("1999-01-01T00:00:00", 999000));
        TestApacheHiveTimestampDecoder.test(-631152000L, 5511111104L, false, TestApacheHiveTimestampDecoder.parseTimestamp("1995-01-01T00:00:00", 688000));
        TestApacheHiveTimestampDecoder.test(-410227200L, 15L, false, TestApacheHiveTimestampDecoder.parseTimestamp("2002-01-01T00:00:00", 100000));
        TestApacheHiveTimestampDecoder.test(-152582400L, 72008L, false, TestApacheHiveTimestampDecoder.parseTimestamp("2010-03-02T00:00:00", 0));
        TestApacheHiveTimestampDecoder.test(-315532800L, 17832L, false, TestApacheHiveTimestampDecoder.parseTimestamp("2005-01-01T00:00:00", 0));
        TestApacheHiveTimestampDecoder.test(-283996800L, 7201624024L, false, TestApacheHiveTimestampDecoder.parseTimestamp("2006-01-01T00:00:00", 900000));
        TestApacheHiveTimestampDecoder.test(-378691200L, 6400000056L, false, TestApacheHiveTimestampDecoder.parseTimestamp("2003-01-01T00:00:00", 800000));
        TestApacheHiveTimestampDecoder.test(-581130000L, 5784806472L, false, TestApacheHiveTimestampDecoder.parseTimestamp("1996-08-01T23:00:00", 723000));
        TestApacheHiveTimestampDecoder.test(-510105600L, 6858725144L, false, TestApacheHiveTimestampDecoder.parseTimestamp("1998-11-02T00:00:00", 857000));
        TestApacheHiveTimestampDecoder.test(-197168400L, 0L, false, TestApacheHiveTimestampDecoder.parseTimestamp("2008-10-01T23:00:00", 0));
    }

    private static void test(long seconds, long nanos, boolean microsecondsPrecision, Timestamp expected) {
        long tsAsLong = ApacheHiveTimestampDecoder.decodeTimestamp((long)seconds, (long)nanos, (DecodeTimestampOptions)new DecodeTimestampOptions(DateTimeZone.UTC, microsecondsPrecision));
        TimeUnit unit = microsecondsPrecision ? TimeUnit.MICROSECONDS : TimeUnit.MILLISECONDS;
        long unitsPerSec = unit.convert(1L, TimeUnit.SECONDS);
        Timestamp ts = new Timestamp(1000L * (tsAsLong / unitsPerSec));
        ts.setNanos((int)TimeUnit.NANOSECONDS.convert(tsAsLong % unitsPerSec, unit));
        Assert.assertEquals((Object)ts, (Object)expected);
    }

    private static Timestamp parseTimestamp(String s, int micros) {
        Timestamp ts = new Timestamp(DateTime.parse((String)s, (DateTimeFormatter)ISODateTimeFormat.dateTimeParser().withZoneUTC()).getMillis());
        ts.setNanos((int)TimeUnit.MICROSECONDS.toNanos(micros));
        return ts;
    }
}

