/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcDecompressor;
import com.facebook.presto.orc.checkpoint.StreamCheckpoint;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.stream.ValueInputStream;
import com.facebook.presto.orc.stream.ValueOutputStream;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;

public abstract class AbstractTestValueStream<T, C extends StreamCheckpoint, W extends ValueOutputStream<C>, R extends ValueInputStream<C>> {
    private static final DataSize COMPRESSION_BLOCK_SIZE = new DataSize(256.0, DataSize.Unit.KILOBYTE);
    static final OrcDataSourceId ORC_DATA_SOURCE_ID = new OrcDataSourceId("test");

    protected void testWriteValue(List<List<T>> groups) throws IOException {
        W outputStream = this.createValueOutputStream();
        for (int i = 0; i < 3; ++i) {
            outputStream.reset();
            long retainedBytes = 0L;
            for (List<Object> list : groups) {
                outputStream.recordCheckpoint();
                list.forEach(value -> this.writeValue(outputStream, value));
                Assert.assertTrue((outputStream.getRetainedBytes() >= retainedBytes ? 1 : 0) != 0);
                retainedBytes = outputStream.getRetainedBytes();
            }
            outputStream.close();
            DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1000);
            StreamDataOutput streamDataOutput = outputStream.getStreamDataOutput(33, 0);
            streamDataOutput.writeData((SliceOutput)sliceOutput);
            Stream stream = streamDataOutput.getStream();
            Assert.assertEquals((Object)stream.getStreamKind(), (Object)this.getExpectedStreamKind());
            Assert.assertEquals((int)stream.getColumn(), (int)33);
            Assert.assertEquals((int)stream.getLength(), (int)sliceOutput.size());
            List checkpoints = outputStream.getCheckpoints();
            Assert.assertEquals((int)checkpoints.size(), (int)groups.size());
            R valueStream = this.createValueStream(sliceOutput.slice());
            for (List<T> group : groups) {
                int index = 0;
                for (T expectedValue : group) {
                    ++index;
                    T actualValue = this.readValue(valueStream);
                    if (actualValue.equals(expectedValue)) continue;
                    Assert.assertEquals(actualValue, expectedValue, (String)("index=" + index));
                }
            }
            for (int groupIndex = groups.size() - 1; groupIndex >= 0; --groupIndex) {
                valueStream.seekToCheckpoint((StreamCheckpoint)checkpoints.get(groupIndex));
                for (T expectedValue : groups.get(groupIndex)) {
                    T actualValue = this.readValue(valueStream);
                    if (actualValue.equals(expectedValue)) continue;
                    Assert.assertEquals(actualValue, expectedValue);
                }
            }
        }
    }

    public Stream.StreamKind getExpectedStreamKind() {
        return Stream.StreamKind.DATA;
    }

    protected ColumnWriterOptions getColumnWriterOptions() {
        return ColumnWriterOptions.builder().setCompressionKind(CompressionKind.SNAPPY).setCompressionMaxBufferSize(COMPRESSION_BLOCK_SIZE).build();
    }

    protected Optional<OrcDecompressor> getOrcDecompressor() {
        return OrcDecompressor.createOrcDecompressor((OrcDataSourceId)ORC_DATA_SOURCE_ID, (CompressionKind)CompressionKind.SNAPPY, (int)Math.toIntExact(COMPRESSION_BLOCK_SIZE.toBytes()));
    }

    protected abstract W createValueOutputStream();

    protected abstract void writeValue(W var1, T var2);

    protected abstract R createValueStream(Slice var1) throws OrcCorruptionException;

    protected abstract T readValue(R var1) throws IOException;
}

