/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.stream.LongBitPacker;
import com.facebook.presto.orc.stream.TestingBitPackingUtils;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.Slices;
import java.io.InputStream;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@Fork(value=2)
@Warmup(iterations=5, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=5, time=500, timeUnit=TimeUnit.MILLISECONDS)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkLongBitPacker {
    @Benchmark
    public Object baselineLength1(BenchmarkData data) throws Throwable {
        data.input.setPosition(0L);
        TestingBitPackingUtils.unpackGeneric(data.buffer, 0, 1, data.bits, (InputStream)data.input);
        return data.buffer;
    }

    @Benchmark
    @OperationsPerInvocation(value=2)
    public Object baselineLength2(BenchmarkData data) throws Throwable {
        data.input.setPosition(0L);
        TestingBitPackingUtils.unpackGeneric(data.buffer, 0, 2, data.bits, (InputStream)data.input);
        return data.buffer;
    }

    @Benchmark
    @OperationsPerInvocation(value=3)
    public Object baselineLength3(BenchmarkData data) throws Throwable {
        data.input.setPosition(0L);
        TestingBitPackingUtils.unpackGeneric(data.buffer, 0, 3, data.bits, (InputStream)data.input);
        return data.buffer;
    }

    @Benchmark
    @OperationsPerInvocation(value=4)
    public Object baselineLength4(BenchmarkData data) throws Throwable {
        data.input.setPosition(0L);
        TestingBitPackingUtils.unpackGeneric(data.buffer, 0, 4, data.bits, (InputStream)data.input);
        return data.buffer;
    }

    @Benchmark
    @OperationsPerInvocation(value=5)
    public Object baselineLength5(BenchmarkData data) throws Throwable {
        data.input.setPosition(0L);
        TestingBitPackingUtils.unpackGeneric(data.buffer, 0, 5, data.bits, (InputStream)data.input);
        return data.buffer;
    }

    @Benchmark
    @OperationsPerInvocation(value=6)
    public Object baselineLength6(BenchmarkData data) throws Throwable {
        data.input.setPosition(0L);
        TestingBitPackingUtils.unpackGeneric(data.buffer, 0, 6, data.bits, (InputStream)data.input);
        return data.buffer;
    }

    @Benchmark
    @OperationsPerInvocation(value=7)
    public Object baselineLength7(BenchmarkData data) throws Throwable {
        data.input.setPosition(0L);
        TestingBitPackingUtils.unpackGeneric(data.buffer, 0, 7, data.bits, (InputStream)data.input);
        return data.buffer;
    }

    @Benchmark
    @OperationsPerInvocation(value=256)
    public Object baselineLength256(BenchmarkData data) throws Throwable {
        data.input.setPosition(0L);
        TestingBitPackingUtils.unpackGeneric(data.buffer, 0, 256, data.bits, (InputStream)data.input);
        return data.buffer;
    }

    @Benchmark
    public Object optimizedLength1(BenchmarkData data) throws Throwable {
        data.input.setPosition(0L);
        data.packer.unpack(data.buffer, 0, 1, data.bits, (InputStream)data.input);
        return data.buffer;
    }

    @Benchmark
    @OperationsPerInvocation(value=2)
    public Object optimizedLength2(BenchmarkData data) throws Throwable {
        data.input.setPosition(0L);
        data.packer.unpack(data.buffer, 0, 2, data.bits, (InputStream)data.input);
        return data.buffer;
    }

    @Benchmark
    @OperationsPerInvocation(value=3)
    public Object optimizedLength3(BenchmarkData data) throws Throwable {
        data.input.setPosition(0L);
        data.packer.unpack(data.buffer, 0, 3, data.bits, (InputStream)data.input);
        return data.buffer;
    }

    @Benchmark
    @OperationsPerInvocation(value=4)
    public Object optimizedLength4(BenchmarkData data) throws Throwable {
        data.input.setPosition(0L);
        data.packer.unpack(data.buffer, 0, 4, data.bits, (InputStream)data.input);
        return data.buffer;
    }

    @Benchmark
    @OperationsPerInvocation(value=5)
    public Object optimizedLength5(BenchmarkData data) throws Throwable {
        data.input.setPosition(0L);
        data.packer.unpack(data.buffer, 0, 5, data.bits, (InputStream)data.input);
        return data.buffer;
    }

    @Benchmark
    @OperationsPerInvocation(value=6)
    public Object optimizedLength6(BenchmarkData data) throws Throwable {
        data.input.setPosition(0L);
        data.packer.unpack(data.buffer, 0, 6, data.bits, (InputStream)data.input);
        return data.buffer;
    }

    @Benchmark
    @OperationsPerInvocation(value=7)
    public Object optimizedLength7(BenchmarkData data) throws Throwable {
        data.input.setPosition(0L);
        data.packer.unpack(data.buffer, 0, 7, data.bits, (InputStream)data.input);
        return data.buffer;
    }

    @Benchmark
    @OperationsPerInvocation(value=256)
    public Object optimizedLength256(BenchmarkData data) throws Throwable {
        data.input.setPosition(0L);
        data.packer.unpack(data.buffer, 0, 256, data.bits, (InputStream)data.input);
        return data.buffer;
    }

    public static void main(String[] args) throws Throwable {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkLongBitPacker().baselineLength256(data);
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkLongBitPacker.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private final long[] buffer = new long[256];
        private final LongBitPacker packer = new LongBitPacker();
        @Param(value={"1", "2", "4", "8", "16", "24", "32", "40", "48", "56", "64"})
        private int bits;
        private BasicSliceInput input;

        @Setup
        public void setup() {
            byte[] bytes = new byte[16384];
            ThreadLocalRandom.current().nextBytes(bytes);
            this.input = Slices.wrappedBuffer((byte[])bytes).getInput();
        }
    }
}

