/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.OrcOutputBuffer;
import com.facebook.presto.orc.checkpoint.BooleanStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.ByteStreamCheckpoint;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.stream.BooleanOutputStream;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.units.DataSize;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBooleanOutputStream {
    @Test
    public void testWriteBoolean() {
        ImmutableList testGroups = ImmutableList.of((Object)ImmutableList.of((Object)149, (Object)317, (Object)2), (Object)ImmutableList.of((Object)2), (Object)ImmutableList.of((Object)1, (Object)2, (Object)4, (Object)0, (Object)8), (Object)ImmutableList.of((Object)1, (Object)4, (Object)8, (Object)1024, (Object)10000), (Object)ImmutableList.of((Object)14000, (Object)1, (Object)2));
        DataSize compressionSize = new DataSize(1.0, DataSize.Unit.KILOBYTE);
        for (List counts : testGroups) {
            int i;
            ColumnWriterOptions columnWriterOptions = ColumnWriterOptions.builder().setCompressionKind(CompressionKind.NONE).setCompressionMaxBufferSize(compressionSize).build();
            OrcOutputBuffer buffer = new OrcOutputBuffer(columnWriterOptions, Optional.empty());
            BooleanOutputStream output = new BooleanOutputStream(buffer);
            Iterator iterator = counts.iterator();
            while (iterator.hasNext()) {
                int count = (Integer)iterator.next();
                output.writeBooleans(count, true);
                output.recordCheckpoint();
            }
            output.close();
            List batchWriteCheckpoints = output.getCheckpoints();
            DynamicSliceOutput slice = new DynamicSliceOutput(128);
            buffer.writeDataTo((SliceOutput)slice);
            Slice batchWriteBuffer = slice.slice();
            buffer.reset();
            output.reset();
            Iterator iterator2 = counts.iterator();
            while (iterator2.hasNext()) {
                int count = (Integer)iterator2.next();
                for (i = 0; i < count; ++i) {
                    output.writeBoolean(true);
                }
                output.recordCheckpoint();
            }
            output.close();
            List singleWriteCheckpoints = output.getCheckpoints();
            slice = new DynamicSliceOutput(128);
            buffer.writeDataTo((SliceOutput)slice);
            Slice singleWriteBuffer = slice.slice();
            Assert.assertEquals((int)batchWriteCheckpoints.size(), (int)singleWriteCheckpoints.size());
            for (i = 0; i < batchWriteCheckpoints.size(); ++i) {
                Assert.assertTrue((boolean)TestBooleanOutputStream.checkpointsEqual((BooleanStreamCheckpoint)batchWriteCheckpoints.get(i), (BooleanStreamCheckpoint)singleWriteCheckpoints.get(i)));
            }
            Assert.assertEquals((Object)batchWriteBuffer, (Object)singleWriteBuffer);
        }
    }

    private static boolean checkpointsEqual(BooleanStreamCheckpoint left, BooleanStreamCheckpoint right) {
        Assert.assertNotNull((Object)left);
        Assert.assertNotNull((Object)right);
        if (left.getOffset() != right.getOffset()) {
            return false;
        }
        ByteStreamCheckpoint leftCheckpoint = left.getByteStreamCheckpoint();
        ByteStreamCheckpoint rightCheckpoint = right.getByteStreamCheckpoint();
        Assert.assertNotNull((Object)leftCheckpoint);
        Assert.assertNotNull((Object)rightCheckpoint);
        return leftCheckpoint.getInputStreamCheckpoint() == rightCheckpoint.getInputStreamCheckpoint() && leftCheckpoint.getOffset() == rightCheckpoint.getOffset();
    }
}

