/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.TestingHiveOrcAggregatedMemoryContext;
import com.facebook.presto.orc.checkpoint.BooleanStreamCheckpoint;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.AbstractTestValueStream;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.BooleanOutputStream;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.SharedBuffer;
import com.facebook.presto.orc.stream.StreamDataOutput;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBooleanStream
extends AbstractTestValueStream<Boolean, BooleanStreamCheckpoint, BooleanOutputStream, BooleanInputStream> {
    @Test
    public void test() throws IOException {
        ArrayList groups = new ArrayList();
        for (int groupIndex = 0; groupIndex < 3; ++groupIndex) {
            ArrayList<Boolean> group = new ArrayList<Boolean>();
            for (int i = 0; i < 1000; ++i) {
                group.add(i % 3 == 0);
            }
            groups.add(group);
        }
        ArrayList<Boolean> group = new ArrayList<Boolean>();
        for (int i = 0; i < 17; ++i) {
            group.add(i % 3 == 0);
        }
        groups.add(group);
        this.testWriteValue(groups);
    }

    @Test
    public void testGetSetBits() throws IOException {
        BooleanOutputStream outputStream = this.createValueOutputStream();
        for (int i = 0; i < 100; ++i) {
            outputStream.writeBoolean(true);
            outputStream.writeBoolean(false);
        }
        outputStream.close();
        BooleanInputStream valueStream = this.createValueStream(outputStream);
        this.assertAlternatingValues(valueStream, 7, true);
        this.assertAlternatingValues(valueStream, 7, false);
        this.assertAlternatingValues(valueStream, 7, true);
        this.assertAlternatingValues(valueStream, 7, false);
        this.assertAlternatingValues(valueStream, 7, true);
        this.assertAlternatingValues(valueStream, 7, false);
        this.assertAlternatingValues(valueStream, 7, true);
        this.assertAlternatingValues(valueStream, 7, false);
        this.assertAlternatingValues(valueStream, 15, true);
        this.assertAlternatingValues(valueStream, 10, false);
    }

    private void assertAlternatingValues(BooleanInputStream valueStream, int batchSize, boolean expectedFirstValue) throws IOException {
        boolean[] data = new boolean[batchSize];
        int setBits = valueStream.getSetBits(batchSize, data);
        Assert.assertEquals((int)setBits, (int)((int)(expectedFirstValue ? Math.ceil((double)batchSize / 2.0) : Math.floor((double)batchSize / 2.0))));
        boolean expectedValue = expectedFirstValue;
        for (int i = 0; i < batchSize; ++i) {
            Assert.assertEquals((boolean)data[i], (boolean)expectedValue);
            expectedValue = !expectedValue;
        }
    }

    @Test
    public void testWriteMultiple() throws IOException {
        BooleanOutputStream outputStream = this.createValueOutputStream();
        for (int i = 0; i < 3; ++i) {
            outputStream.reset();
            BooleanArrayList expectedValues = new BooleanArrayList(1024);
            outputStream.writeBooleans(32, true);
            expectedValues.addAll(Collections.nCopies(32, true));
            outputStream.writeBooleans(32, false);
            expectedValues.addAll(Collections.nCopies(32, false));
            outputStream.writeBooleans(1, true);
            expectedValues.add(true);
            outputStream.writeBooleans(1, false);
            expectedValues.add(false);
            outputStream.writeBooleans(34, true);
            expectedValues.addAll(Collections.nCopies(34, true));
            outputStream.writeBooleans(34, false);
            expectedValues.addAll(Collections.nCopies(34, false));
            outputStream.writeBoolean(true);
            expectedValues.add(true);
            outputStream.writeBoolean(false);
            expectedValues.add(false);
            outputStream.close();
            BooleanInputStream valueStream = this.createValueStream(outputStream);
            for (int index = 0; index < expectedValues.size(); ++index) {
                boolean expectedValue = expectedValues.getBoolean(index);
                boolean actualValue = this.readValue(valueStream);
                Assert.assertEquals((boolean)actualValue, (boolean)expectedValue);
            }
        }
    }

    @Override
    protected BooleanOutputStream createValueOutputStream() {
        return new BooleanOutputStream(this.getColumnWriterOptions(), Optional.empty());
    }

    @Override
    protected void writeValue(BooleanOutputStream outputStream, Boolean value) {
        outputStream.writeBoolean(value.booleanValue());
    }

    @Override
    protected BooleanInputStream createValueStream(Slice slice) throws OrcCorruptionException {
        TestingHiveOrcAggregatedMemoryContext aggregatedMemoryContext = new TestingHiveOrcAggregatedMemoryContext();
        return new BooleanInputStream(new OrcInputStream(ORC_DATA_SOURCE_ID, new SharedBuffer(aggregatedMemoryContext.newOrcLocalMemoryContext("sharedDecompressionBuffer")), (FixedLengthSliceInput)slice.getInput(), this.getOrcDecompressor(), Optional.empty(), (OrcAggregatedMemoryContext)aggregatedMemoryContext, slice.getRetainedSize()));
    }

    @Override
    protected Boolean readValue(BooleanInputStream valueStream) throws IOException {
        return valueStream.nextBit();
    }

    private BooleanInputStream createValueStream(BooleanOutputStream outputStream) throws OrcCorruptionException {
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1000);
        StreamDataOutput streamDataOutput = outputStream.getStreamDataOutput(33, 0);
        streamDataOutput.writeData((SliceOutput)sliceOutput);
        Stream stream = streamDataOutput.getStream();
        Assert.assertEquals((Object)stream.getStreamKind(), (Object)this.getExpectedStreamKind());
        Assert.assertEquals((int)stream.getColumn(), (int)33);
        Assert.assertEquals((int)stream.getLength(), (int)sliceOutput.size());
        return this.createValueStream(sliceOutput.slice());
    }
}

