/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.TestingHiveOrcAggregatedMemoryContext;
import com.facebook.presto.orc.checkpoint.ByteStreamCheckpoint;
import com.facebook.presto.orc.stream.AbstractTestValueStream;
import com.facebook.presto.orc.stream.ByteInputStream;
import com.facebook.presto.orc.stream.ByteOutputStream;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.SharedBuffer;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestByteStream
extends AbstractTestValueStream<Byte, ByteStreamCheckpoint, ByteOutputStream, ByteInputStream> {
    @Test
    public void testLiteral() throws IOException {
        ArrayList groups = new ArrayList();
        for (int groupIndex = 0; groupIndex < 3; ++groupIndex) {
            ArrayList<Byte> group = new ArrayList<Byte>();
            for (int i = 0; i < 1000; ++i) {
                group.add((byte)(groupIndex * 10000 + i));
            }
            groups.add(group);
        }
        this.testWriteValue(groups);
    }

    @Test
    public void testRleLong() throws IOException {
        ArrayList groups = new ArrayList();
        for (int groupIndex = 0; groupIndex < 3; ++groupIndex) {
            ArrayList<Byte> group = new ArrayList<Byte>();
            for (int i = 0; i < 1000; ++i) {
                group.add((byte)77);
            }
            groups.add(group);
        }
        this.testWriteValue(groups);
    }

    @Test
    public void testRleShort() throws IOException {
        ArrayList groups = new ArrayList();
        for (int groupIndex = 0; groupIndex < 3; ++groupIndex) {
            ArrayList<Byte> group = new ArrayList<Byte>();
            for (int i = 0; i < 1000; ++i) {
                group.add((byte)((groupIndex * 10000 + i) / 13));
            }
            groups.add(group);
        }
        this.testWriteValue(groups);
    }

    @Override
    protected ByteOutputStream createValueOutputStream() {
        return new ByteOutputStream(this.getColumnWriterOptions(), Optional.empty());
    }

    @Override
    protected void writeValue(ByteOutputStream outputStream, Byte value) {
        outputStream.writeByte(value.byteValue());
    }

    @Override
    protected ByteInputStream createValueStream(Slice slice) throws OrcCorruptionException {
        TestingHiveOrcAggregatedMemoryContext aggregatedMemoryContext = new TestingHiveOrcAggregatedMemoryContext();
        return new ByteInputStream(new OrcInputStream(ORC_DATA_SOURCE_ID, new SharedBuffer(aggregatedMemoryContext.newOrcLocalMemoryContext("sharedDecompressionBuffer")), (FixedLengthSliceInput)slice.getInput(), this.getOrcDecompressor(), Optional.empty(), (OrcAggregatedMemoryContext)aggregatedMemoryContext, slice.getRetainedSize()));
    }

    @Override
    protected Byte readValue(ByteInputStream valueStream) throws IOException {
        return valueStream.next();
    }
}

