/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.UnscaledDecimal128Arithmetic;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.TestingHiveOrcAggregatedMemoryContext;
import com.facebook.presto.orc.stream.DecimalInputStream;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.SharedBuffer;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDecimalStream {
    private static final BigInteger BIG_INTEGER_127_BIT_SET;

    @Test
    public void testShortDecimals() throws IOException {
        TestDecimalStream.assertReadsShortValue(0L);
        TestDecimalStream.assertReadsShortValue(1L);
        TestDecimalStream.assertReadsShortValue(-1L);
        TestDecimalStream.assertReadsShortValue(256L);
        TestDecimalStream.assertReadsShortValue(-256L);
        TestDecimalStream.assertReadsShortValue(Long.MAX_VALUE);
        TestDecimalStream.assertReadsShortValue(Long.MIN_VALUE);
    }

    @Test
    public void testShouldFailWhenShortDecimalDoesNotFit() {
        TestDecimalStream.assertShortValueReadFails(BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE));
    }

    @Test
    public void testShouldFailWhenExceeds128Bits() {
        TestDecimalStream.assertLongValueReadFails(BigInteger.valueOf(1L).shiftLeft(127));
        TestDecimalStream.assertLongValueReadFails(BigInteger.valueOf(-2L).shiftLeft(127));
    }

    @Test
    public void testLongDecimals() throws IOException {
        TestDecimalStream.assertReadsLongValue(BigInteger.valueOf(0L));
        TestDecimalStream.assertReadsLongValue(BigInteger.valueOf(1L));
        TestDecimalStream.assertReadsLongValue(BigInteger.valueOf(-1L));
        TestDecimalStream.assertReadsLongValue(BigInteger.valueOf(-1L).shiftLeft(126));
        TestDecimalStream.assertReadsLongValue(BigInteger.valueOf(1L).shiftLeft(126));
        TestDecimalStream.assertReadsLongValue(BIG_INTEGER_127_BIT_SET);
        TestDecimalStream.assertReadsLongValue(BIG_INTEGER_127_BIT_SET.negate());
        TestDecimalStream.assertReadsLongValue(Decimals.MAX_DECIMAL_UNSCALED_VALUE);
        TestDecimalStream.assertReadsLongValue(Decimals.MIN_DECIMAL_UNSCALED_VALUE);
    }

    @Test
    public void testSkipsValue() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TestDecimalStream.writeBigInteger(baos, BigInteger.valueOf(Long.MAX_VALUE));
        TestDecimalStream.writeBigInteger(baos, BigInteger.valueOf(Long.MIN_VALUE));
        OrcInputStream inputStream = TestDecimalStream.orcInputStreamFor("skip test", baos.toByteArray());
        DecimalInputStream stream = new DecimalInputStream(inputStream);
        stream.skip(1L);
        Assert.assertEquals((long)stream.nextLong(), (long)Long.MIN_VALUE);
    }

    private static void assertReadsShortValue(long value) throws IOException {
        DecimalInputStream stream = new DecimalInputStream(TestDecimalStream.decimalInputStream(BigInteger.valueOf(value)));
        Assert.assertEquals((long)stream.nextLong(), (long)value);
    }

    private static void assertReadsLongValue(BigInteger value) throws IOException {
        DecimalInputStream stream = new DecimalInputStream(TestDecimalStream.decimalInputStream(value));
        Slice decimal = UnscaledDecimal128Arithmetic.unscaledDecimal();
        stream.nextLongDecimal(decimal);
        Assert.assertEquals((Object)UnscaledDecimal128Arithmetic.unscaledDecimalToBigInteger((Slice)decimal), (Object)value);
    }

    private static void assertShortValueReadFails(BigInteger value) {
        Assert.assertThrows(OrcCorruptionException.class, () -> {
            DecimalInputStream stream = new DecimalInputStream(TestDecimalStream.decimalInputStream(value));
            stream.nextLong();
        });
    }

    private static void assertLongValueReadFails(BigInteger value) {
        Slice decimal = UnscaledDecimal128Arithmetic.unscaledDecimal();
        Assert.assertThrows(OrcCorruptionException.class, () -> {
            DecimalInputStream stream = new DecimalInputStream(TestDecimalStream.decimalInputStream(value));
            stream.nextLongDecimal(decimal);
        });
    }

    private static OrcInputStream decimalInputStream(BigInteger value) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TestDecimalStream.writeBigInteger(baos, value);
        return TestDecimalStream.orcInputStreamFor(value.toString(), baos.toByteArray());
    }

    private static OrcInputStream orcInputStreamFor(String source, byte[] bytes) {
        TestingHiveOrcAggregatedMemoryContext aggregatedMemoryContext = new TestingHiveOrcAggregatedMemoryContext();
        return new OrcInputStream(new OrcDataSourceId(source), new SharedBuffer(aggregatedMemoryContext.newOrcLocalMemoryContext("sharedDecompressionBuffer")), (FixedLengthSliceInput)new BasicSliceInput(Slices.wrappedBuffer((byte[])bytes)), Optional.empty(), Optional.empty(), (OrcAggregatedMemoryContext)aggregatedMemoryContext, (long)bytes.length);
    }

    private static void writeBigInteger(OutputStream output, BigInteger value) throws IOException {
        int sign = (value = value.shiftLeft(1)).signum();
        if (sign < 0) {
            value = value.negate();
            value = value.subtract(BigInteger.ONE);
        }
        int length = value.bitLength();
        while (true) {
            long lowBits = value.longValue() & Long.MAX_VALUE;
            length -= 63;
            for (int i = 0; i < 9; ++i) {
                if (length <= 0 && (lowBits & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    output.write((byte)lowBits);
                    return;
                }
                output.write((byte)(0x80L | lowBits & 0x7FL));
                lowBits >>>= 7;
            }
            value = value.shiftRight(63);
        }
    }

    static {
        BigInteger b = BigInteger.ZERO;
        for (int i = 0; i < 127; ++i) {
            b = b.setBit(i);
        }
        BIG_INTEGER_127_BIT_SET = b;
    }
}

