/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.TestingHiveOrcAggregatedMemoryContext;
import com.facebook.presto.orc.checkpoint.DoubleStreamCheckpoint;
import com.facebook.presto.orc.stream.AbstractTestValueStream;
import com.facebook.presto.orc.stream.DoubleInputStream;
import com.facebook.presto.orc.stream.DoubleOutputStream;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.SharedBuffer;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestDoubleStream
extends AbstractTestValueStream<Double, DoubleStreamCheckpoint, DoubleOutputStream, DoubleInputStream> {
    @Test
    public void test() throws IOException {
        ArrayList groups = new ArrayList();
        for (int groupIndex = 0; groupIndex < 3; ++groupIndex) {
            ArrayList<Double> group = new ArrayList<Double>();
            for (int i = 0; i < 1000; ++i) {
                group.add(Double.valueOf(groupIndex * 10000 + i));
            }
            groups.add(group);
        }
        this.testWriteValue(groups);
    }

    @Override
    protected DoubleOutputStream createValueOutputStream() {
        return new DoubleOutputStream(this.getColumnWriterOptions(), Optional.empty());
    }

    @Override
    protected void writeValue(DoubleOutputStream outputStream, Double value) {
        outputStream.writeDouble(value.doubleValue());
    }

    @Override
    protected DoubleInputStream createValueStream(Slice slice) throws OrcCorruptionException {
        TestingHiveOrcAggregatedMemoryContext aggregatedMemoryContext = new TestingHiveOrcAggregatedMemoryContext();
        return new DoubleInputStream(new OrcInputStream(ORC_DATA_SOURCE_ID, new SharedBuffer(aggregatedMemoryContext.newOrcLocalMemoryContext("sharedDecompressionBuffer")), (FixedLengthSliceInput)slice.getInput(), this.getOrcDecompressor(), Optional.empty(), (OrcAggregatedMemoryContext)aggregatedMemoryContext, slice.getRetainedSize()));
    }

    @Override
    protected Double readValue(DoubleInputStream valueStream) throws IOException {
        return valueStream.next();
    }
}

