/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.TestingHiveOrcAggregatedMemoryContext;
import com.facebook.presto.orc.checkpoint.FloatStreamCheckpoint;
import com.facebook.presto.orc.stream.AbstractTestValueStream;
import com.facebook.presto.orc.stream.FloatInputStream;
import com.facebook.presto.orc.stream.FloatOutputStream;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.SharedBuffer;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestFloatStream
extends AbstractTestValueStream<Float, FloatStreamCheckpoint, FloatOutputStream, FloatInputStream> {
    @Test
    public void test() throws IOException {
        ArrayList groups = new ArrayList();
        for (int groupIndex = 0; groupIndex < 3; ++groupIndex) {
            ArrayList<Float> group = new ArrayList<Float>();
            for (int i = 0; i < 1000; ++i) {
                group.add(Float.valueOf(groupIndex * 10000 + i));
            }
            groups.add(group);
        }
        this.testWriteValue(groups);
    }

    @Override
    protected FloatOutputStream createValueOutputStream() {
        return new FloatOutputStream(this.getColumnWriterOptions(), Optional.empty());
    }

    @Override
    protected void writeValue(FloatOutputStream outputStream, Float value) {
        outputStream.writeFloat(value.floatValue());
    }

    @Override
    protected FloatInputStream createValueStream(Slice slice) throws OrcCorruptionException {
        TestingHiveOrcAggregatedMemoryContext aggregatedMemoryContext = new TestingHiveOrcAggregatedMemoryContext();
        return new FloatInputStream(new OrcInputStream(ORC_DATA_SOURCE_ID, new SharedBuffer(aggregatedMemoryContext.newOrcLocalMemoryContext("sharedDecompressionBuffer")), (FixedLengthSliceInput)slice.getInput(), this.getOrcDecompressor(), Optional.empty(), (OrcAggregatedMemoryContext)aggregatedMemoryContext, slice.getRetainedSize()));
    }

    @Override
    protected Float readValue(FloatInputStream valueStream) throws IOException {
        return Float.valueOf(valueStream.next());
    }
}

