/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.stream.LongBitPacker;
import com.facebook.presto.orc.stream.TestingBitPackingUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLongBitPacker {
    public static final int LENGTHS = 128;
    public static final int OFFSETS = 4;
    public static final int WIDTHS = 64;

    @Test
    public void testBasic() throws Throwable {
        LongBitPacker packer = new LongBitPacker();
        for (int length = 0; length < 128; ++length) {
            TestLongBitPacker.assertUnpacking(packer, length);
        }
    }

    private static void assertUnpacking(LongBitPacker packer, int length) throws IOException {
        for (int width = 1; width <= 64; ++width) {
            for (int offset = 0; offset < 4; ++offset) {
                long[] expected = new long[length + offset];
                long[] actual = new long[length + offset];
                RandomByteInputStream expectedInput = new RandomByteInputStream();
                TestingBitPackingUtils.unpackGeneric(expected, offset, length, width, expectedInput);
                RandomByteInputStream actualInput = new RandomByteInputStream();
                packer.unpack(actual, offset, length, width, (InputStream)actualInput);
                for (int i = offset; i < length + offset; ++i) {
                    Assert.assertEquals((long)actual[i], (long)expected[i], (String)String.format("index = %s, length = %s, width = %s, offset = %s", i, length, width, offset));
                }
                Assert.assertEquals((int)actualInput.getReadBytes(), (int)expectedInput.getReadBytes(), (String)String.format("Wrong number of bytes read for length = %s, width = %s, offset = %s", length, width, offset));
            }
        }
    }

    private static final class RandomByteInputStream
    extends InputStream {
        private final Random rand = new Random(0L);
        private int readBytes;

        private RandomByteInputStream() {
        }

        @Override
        public int read() {
            ++this.readBytes;
            return this.rand.nextInt(256);
        }

        public int getReadBytes() {
            return this.readBytes;
        }
    }
}

