/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.common.type.UnscaledDecimal128Arithmetic;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.TestingHiveOrcAggregatedMemoryContext;
import com.facebook.presto.orc.checkpoint.DecimalStreamCheckpoint;
import com.facebook.presto.orc.stream.AbstractTestValueStream;
import com.facebook.presto.orc.stream.DecimalInputStream;
import com.facebook.presto.orc.stream.DecimalOutputStream;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.SharedBuffer;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import org.testng.annotations.Test;

public class TestLongDecimalStream
extends AbstractTestValueStream<Slice, DecimalStreamCheckpoint, DecimalOutputStream, DecimalInputStream> {
    @Test
    public void test() throws IOException {
        Random random = new Random(0L);
        ArrayList groups = new ArrayList();
        for (int groupIndex = 0; groupIndex < 3; ++groupIndex) {
            ArrayList<Slice> group = new ArrayList<Slice>();
            for (int i = 0; i < 1000; ++i) {
                BigInteger value = new BigInteger(120, random);
                group.add(UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)value));
            }
            groups.add(group);
        }
        this.testWriteValue(groups);
    }

    @Override
    protected DecimalOutputStream createValueOutputStream() {
        return new DecimalOutputStream(this.getColumnWriterOptions());
    }

    @Override
    protected void writeValue(DecimalOutputStream outputStream, Slice value) {
        outputStream.writeUnscaledValue(value);
    }

    @Override
    protected DecimalInputStream createValueStream(Slice slice) throws OrcCorruptionException {
        TestingHiveOrcAggregatedMemoryContext aggregatedMemoryContext = new TestingHiveOrcAggregatedMemoryContext();
        return new DecimalInputStream(new OrcInputStream(ORC_DATA_SOURCE_ID, new SharedBuffer(aggregatedMemoryContext.newOrcLocalMemoryContext("sharedDecompressionBuffer")), (FixedLengthSliceInput)slice.getInput(), this.getOrcDecompressor(), Optional.empty(), (OrcAggregatedMemoryContext)aggregatedMemoryContext, slice.getRetainedSize()));
    }

    @Override
    protected Slice readValue(DecimalInputStream valueStream) throws IOException {
        Slice decimal = UnscaledDecimal128Arithmetic.unscaledDecimal();
        valueStream.nextLongDecimal(decimal);
        return decimal;
    }
}

