/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.TestingHiveOrcAggregatedMemoryContext;
import com.facebook.presto.orc.stream.LongDecode;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.SharedBuffer;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLongDecode {
    @Test
    public void testVInt() throws Exception {
        Slice slice = Slices.allocate((int)100);
        SliceOutput output = slice.getOutput();
        TestLongDecode.assertVIntRoundTrip(output, 0L);
        TestLongDecode.assertVIntRoundTrip(output, 1L);
        TestLongDecode.assertVIntRoundTrip(output, -1L);
        TestLongDecode.assertVIntRoundTrip(output, Integer.MAX_VALUE);
        TestLongDecode.assertVIntRoundTrip(output, 0x80000000L);
        TestLongDecode.assertVIntRoundTrip(output, 0x7FFFFFFEL);
        TestLongDecode.assertVIntRoundTrip(output, Integer.MIN_VALUE);
        TestLongDecode.assertVIntRoundTrip(output, -2147483647L);
        TestLongDecode.assertVIntRoundTrip(output, -2147483649L);
        TestLongDecode.assertVIntRoundTrip(output, Long.MAX_VALUE);
        TestLongDecode.assertVIntRoundTrip(output, 0x7FFFFFFFFFFFFFFEL);
        TestLongDecode.assertVIntRoundTrip(output, -9223372036854775807L);
        for (int value = -100000; value < 100000; ++value) {
            TestLongDecode.assertVIntRoundTrip(output, value);
        }
    }

    private static void assertVIntRoundTrip(SliceOutput output, long value) throws IOException {
        TestLongDecode.assertVIntRoundTrip(output, value, true);
        TestLongDecode.assertVIntRoundTrip(output, value, false);
    }

    private static void assertVIntRoundTrip(SliceOutput output, long value, boolean signed) throws IOException {
        long readValueOld;
        output.reset();
        if (signed) {
            TestLongDecode.writeVslong((OutputStream)output, value);
        } else {
            TestLongDecode.writeVulong((OutputStream)output, value);
        }
        Slice hiveBytes = Slices.copyOf((Slice)output.slice());
        output.reset();
        LongDecode.writeVLong((SliceOutput)output, (long)value, (boolean)signed);
        Slice prestoBytes = Slices.copyOf((Slice)output.slice());
        if (!prestoBytes.equals((Object)hiveBytes)) {
            Assert.assertEquals((Object)prestoBytes, (Object)hiveBytes);
        }
        if (signed) {
            readValueOld = TestLongDecode.readVslong((InputStream)hiveBytes.getInput());
            Assert.assertEquals((long)readValueOld, (long)value);
        } else {
            readValueOld = TestLongDecode.readVulong((InputStream)hiveBytes.getInput());
            Assert.assertEquals((long)readValueOld, (long)value);
        }
        TestingHiveOrcAggregatedMemoryContext aggregatedMemoryContext = new TestingHiveOrcAggregatedMemoryContext();
        long readValueNew = LongDecode.readVInt((boolean)signed, (OrcInputStream)new OrcInputStream(new OrcDataSourceId("test"), new SharedBuffer(aggregatedMemoryContext.newOrcLocalMemoryContext("sharedDecompressionBuffer")), (FixedLengthSliceInput)hiveBytes.getInput(), Optional.empty(), Optional.empty(), (OrcAggregatedMemoryContext)aggregatedMemoryContext, hiveBytes.getRetainedSize()));
        Assert.assertEquals((long)readValueNew, (long)value);
    }

    private static void writeVulong(OutputStream output, long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                output.write((byte)value);
                return;
            }
            output.write((byte)(0x80L | value & 0x7FL));
            value >>>= 7;
        }
    }

    private static void writeVslong(OutputStream output, long value) throws IOException {
        TestLongDecode.writeVulong(output, value << 1 ^ value >> 63);
    }

    private static long readVulong(InputStream in) throws IOException {
        long b;
        long result = 0L;
        int offset = 0;
        do {
            if ((b = (long)in.read()) == -1L) {
                throw new EOFException("Reading Vulong past EOF");
            }
            result |= (0x7FL & b) << offset;
            offset += 7;
        } while (b >= 128L);
        return result;
    }

    private static long readVslong(InputStream in) throws IOException {
        long result = TestLongDecode.readVulong(in);
        return result >>> 1 ^ -(result & 1L);
    }
}

