/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.TestingHiveOrcAggregatedMemoryContext;
import com.facebook.presto.orc.checkpoint.LongStreamCheckpoint;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.AbstractTestValueStream;
import com.facebook.presto.orc.stream.LongInputStreamDwrf;
import com.facebook.presto.orc.stream.LongOutputStreamDwrf;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.SharedBuffer;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestLongStreamDwrf
extends AbstractTestValueStream<Long, LongStreamCheckpoint, LongOutputStreamDwrf, LongInputStreamDwrf> {
    @Test
    public void test() throws IOException {
        ArrayList groups = new ArrayList();
        for (int groupIndex = 0; groupIndex < 3; ++groupIndex) {
            ArrayList<Long> group = new ArrayList<Long>();
            for (int i = 0; i < 1000; ++i) {
                group.add(Long.valueOf(groupIndex * 10000 + i));
            }
            groups.add(group);
        }
        this.testWriteValue(groups);
    }

    @Override
    protected LongOutputStreamDwrf createValueOutputStream() {
        return new LongOutputStreamDwrf(this.getColumnWriterOptions(), Optional.empty(), true, Stream.StreamKind.DATA);
    }

    @Override
    protected void writeValue(LongOutputStreamDwrf outputStream, Long value) {
        outputStream.writeLong(value.longValue());
    }

    @Override
    protected LongInputStreamDwrf createValueStream(Slice slice) throws OrcCorruptionException {
        TestingHiveOrcAggregatedMemoryContext aggregatedMemoryContext = new TestingHiveOrcAggregatedMemoryContext();
        OrcInputStream input = new OrcInputStream(ORC_DATA_SOURCE_ID, new SharedBuffer(aggregatedMemoryContext.newOrcLocalMemoryContext("sharedDecompressionBuffer")), (FixedLengthSliceInput)slice.getInput(), this.getOrcDecompressor(), Optional.empty(), (OrcAggregatedMemoryContext)aggregatedMemoryContext, slice.getRetainedSize());
        return new LongInputStreamDwrf(input, OrcType.OrcTypeKind.LONG, true, true);
    }

    @Override
    protected Long readValue(LongInputStreamDwrf valueStream) throws IOException {
        return valueStream.next();
    }
}

