/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.TestingHiveOrcAggregatedMemoryContext;
import com.facebook.presto.orc.checkpoint.LongStreamCheckpoint;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.AbstractTestValueStream;
import com.facebook.presto.orc.stream.LongInputStreamV1;
import com.facebook.presto.orc.stream.LongOutputStreamV1;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.SharedBuffer;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import org.testng.annotations.Test;

public class TestLongStreamV1
extends AbstractTestValueStream<Long, LongStreamCheckpoint, LongOutputStreamV1, LongInputStreamV1> {
    @Test
    public void test() throws IOException {
        int i;
        ArrayList groups = new ArrayList();
        ArrayList<Long> group = new ArrayList<Long>();
        for (i = 0; i < 1000; ++i) {
            group.add(Long.valueOf(i));
        }
        groups.add(group);
        group = new ArrayList();
        for (i = 0; i < 1000; ++i) {
            group.add(Long.valueOf(10000 + i * 17));
        }
        groups.add(group);
        group = new ArrayList();
        for (i = 0; i < 1000; ++i) {
            group.add(Long.valueOf(10000 - i * 17));
        }
        groups.add(group);
        group = new ArrayList();
        Random random = new Random(22L);
        for (int i2 = 0; i2 < 1000; ++i2) {
            group.add(-1000L + (long)random.nextInt(17));
        }
        groups.add(group);
        this.testWriteValue(groups);
    }

    @Override
    protected LongOutputStreamV1 createValueOutputStream() {
        return new LongOutputStreamV1(this.getColumnWriterOptions(), Optional.empty(), true, Stream.StreamKind.DATA);
    }

    @Override
    protected void writeValue(LongOutputStreamV1 outputStream, Long value) {
        outputStream.writeLong(value.longValue());
    }

    @Override
    protected LongInputStreamV1 createValueStream(Slice slice) throws OrcCorruptionException {
        TestingHiveOrcAggregatedMemoryContext aggregatedMemoryContext = new TestingHiveOrcAggregatedMemoryContext();
        OrcInputStream input = new OrcInputStream(ORC_DATA_SOURCE_ID, new SharedBuffer(aggregatedMemoryContext.newOrcLocalMemoryContext("sharedDecompressionBuffer")), (FixedLengthSliceInput)slice.getInput(), this.getOrcDecompressor(), Optional.empty(), (OrcAggregatedMemoryContext)aggregatedMemoryContext, slice.getRetainedSize());
        return new LongInputStreamV1(input, true);
    }

    @Override
    protected Long readValue(LongInputStreamV1 valueStream) throws IOException {
        return valueStream.next();
    }
}

