/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import java.io.IOException;
import java.io.InputStream;

public final class TestingBitPackingUtils {
    private TestingBitPackingUtils() {
    }

    public static void unpackGeneric(long[] buffer, int offset, int len, int bitSize, InputStream input) throws IOException {
        int bitsLeft = 0;
        int current = 0;
        for (int i = offset; i < offset + len; ++i) {
            int bitsLeftToRead;
            long result = 0L;
            for (bitsLeftToRead = bitSize; bitsLeftToRead > bitsLeft; bitsLeftToRead -= bitsLeft) {
                result <<= bitsLeft;
                result |= (long)(current & (1 << bitsLeft) - 1);
                current = input.read();
                bitsLeft = 8;
            }
            if (bitsLeftToRead > 0) {
                result <<= bitsLeftToRead;
                result |= (long)(current >> (bitsLeft -= bitsLeftToRead) & (1 << bitsLeftToRead) - 1);
            }
            buffer[i] = result;
        }
    }
}

