/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.DwrfEncryptionInfo;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.facebook.presto.orc.writer.ColumnWriters;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestColumnWriters {
    private static final int SEQUENCE = 98005;

    @DataProvider(name="dataForSequenceIdTest")
    public Object[][] dataForSequenceIdTest() {
        Block stringBlock = VarcharType.VARCHAR.createBlockBuilder(null, 2).appendNull().writeBytes(Slices.utf8Slice((String)"123456789"), 0, 9).closeEntry().build();
        Type mapType = OrcTester.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER);
        BlockBuilder mapBlockBuilder = mapType.createBlockBuilder(null, 3);
        mapBlockBuilder.appendNull();
        mapBlockBuilder.beginBlockEntry().writeInt(1).closeEntry().writeInt(2).closeEntry();
        mapBlockBuilder.closeEntry();
        Block mapBlock = mapBlockBuilder.build();
        Type arrayType = OrcTester.arrayType((Type)IntegerType.INTEGER);
        BlockBuilder arrayBlockBuilder = arrayType.createBlockBuilder(null, 2);
        arrayBlockBuilder.appendNull();
        arrayBlockBuilder.beginBlockEntry().writeInt(1).writeInt(2);
        arrayBlockBuilder.closeEntry();
        arrayBlockBuilder.beginBlockEntry().appendNull();
        arrayBlockBuilder.closeEntry();
        Block arrayBlock = arrayBlockBuilder.build();
        Type rowType = OrcTester.rowType(new Type[]{IntegerType.INTEGER});
        BlockBuilder rowBlockBuilder = rowType.createBlockBuilder(null, 2);
        rowBlockBuilder.appendNull();
        rowBlockBuilder.beginBlockEntry().writeInt(1).closeEntry();
        rowBlockBuilder.closeEntry();
        rowBlockBuilder.beginBlockEntry().appendNull();
        rowBlockBuilder.closeEntry();
        Block rowBlock = rowBlockBuilder.build();
        return new Object[][]{{TestColumnWriters.toOrcTypes((Type)BooleanType.BOOLEAN), BooleanType.BOOLEAN, BooleanType.BOOLEAN.createFixedSizeBlockBuilder(2).appendNull().writeByte(1).build()}, {TestColumnWriters.toOrcTypes((Type)TinyintType.TINYINT), TinyintType.TINYINT, TinyintType.TINYINT.createFixedSizeBlockBuilder(2).appendNull().writeByte(1).build()}, {TestColumnWriters.toOrcTypes((Type)SmallintType.SMALLINT), SmallintType.SMALLINT, SmallintType.SMALLINT.createFixedSizeBlockBuilder(2).appendNull().writeShort(1).build()}, {TestColumnWriters.toOrcTypes((Type)IntegerType.INTEGER), IntegerType.INTEGER, IntegerType.INTEGER.createFixedSizeBlockBuilder(2).appendNull().writeInt(1).build()}, {TestColumnWriters.toOrcTypes((Type)BigintType.BIGINT), BigintType.BIGINT, BigintType.BIGINT.createFixedSizeBlockBuilder(2).appendNull().writeLong(1L).build()}, {TestColumnWriters.toOrcTypes((Type)DoubleType.DOUBLE), DoubleType.DOUBLE, DoubleType.DOUBLE.createFixedSizeBlockBuilder(2).appendNull().writeLong(1L).build()}, {TestColumnWriters.toOrcTypes((Type)RealType.REAL), RealType.REAL, RealType.REAL.createFixedSizeBlockBuilder(2).appendNull().writeInt(1).build()}, {TestColumnWriters.toOrcTypes((Type)TimestampType.TIMESTAMP), TimestampType.TIMESTAMP, TimestampType.TIMESTAMP.createFixedSizeBlockBuilder(2).appendNull().writeLong(1L).build()}, {TestColumnWriters.toOrcTypes((Type)TimestampType.TIMESTAMP_MICROSECONDS), TimestampType.TIMESTAMP_MICROSECONDS, TimestampType.TIMESTAMP_MICROSECONDS.createFixedSizeBlockBuilder(2).appendNull().writeLong(1L).build()}, {TestColumnWriters.toOrcTypes((Type)VarcharType.VARCHAR), VarcharType.VARCHAR, stringBlock}, {TestColumnWriters.toOrcTypes((Type)VarbinaryType.VARBINARY), VarbinaryType.VARBINARY, stringBlock}, {TestColumnWriters.toOrcTypes(arrayType), arrayType, arrayBlock}, {TestColumnWriters.toOrcTypes(mapType), mapType, mapBlock}, {TestColumnWriters.toOrcTypes(rowType), rowType, rowBlock}};
    }

    @Test(dataProvider="dataForSequenceIdTest")
    public void testSequenceIdPassedAllColumnWriters(List<OrcType> orcTypes, Type type, Block block) throws IOException {
        ColumnWriterOptions columnWriterOptions = ColumnWriterOptions.builder().setCompressionKind(CompressionKind.ZLIB).build();
        int nodeId = 0;
        ColumnWriter columnWriter = ColumnWriters.createColumnWriter((int)nodeId, (int)98005, orcTypes, (Type)type, (ColumnWriterOptions)columnWriterOptions, (OrcEncoding)OrcEncoding.DWRF, (DateTimeZone)DateTimeZone.UTC, (DwrfEncryptionInfo)DwrfEncryptionInfo.UNENCRYPTED, (MetadataWriter)OrcEncoding.DWRF.createMetadataWriter());
        columnWriter.beginRowGroup();
        columnWriter.writeBlock(block);
        columnWriter.finishRowGroup();
        columnWriter.close();
        ImmutableList streams = ImmutableList.builder().addAll((Iterable)columnWriter.getIndexStreams(Optional.empty())).addAll((Iterable)columnWriter.getDataStreams()).build();
        for (StreamDataOutput stream : streams) {
            Assert.assertEquals((int)stream.getStream().getSequence(), (int)98005);
        }
    }

    private static List<OrcType> toOrcTypes(Type type) {
        return OrcType.toOrcType((int)0, (Type)type);
    }
}

