/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.orc.writer.CompressionBufferPool;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCompressionBufferPool {
    @Test
    public void testBufferReuse() {
        CompressionBufferPool.LastUsedCompressionBufferPool bufferPool = new CompressionBufferPool.LastUsedCompressionBufferPool();
        byte[] buffer1 = bufferPool.checkOut(0);
        this.verifyBuffer(buffer1, 0);
        bufferPool.checkIn(buffer1);
        byte[] buffer2 = bufferPool.checkOut(0);
        Assert.assertSame((Object)buffer1, (Object)buffer2);
        byte[] buffer3 = bufferPool.checkOut(0);
        Assert.assertNotSame((Object)buffer1, (Object)buffer3);
        this.verifyBuffer(buffer3, 0);
        bufferPool.checkIn(buffer3);
    }

    @Test
    public void testLargeBuffer() {
        CompressionBufferPool.LastUsedCompressionBufferPool bufferPool = new CompressionBufferPool.LastUsedCompressionBufferPool();
        byte[] buffer1 = bufferPool.checkOut(1000);
        this.verifyBuffer(buffer1, 1000);
        bufferPool.checkIn(buffer1);
        byte[] buffer2 = bufferPool.checkOut(500);
        Assert.assertSame((Object)buffer1, (Object)buffer2);
        bufferPool.checkIn(buffer2);
        byte[] buffer3 = bufferPool.checkOut(2000);
        this.verifyBuffer(buffer3, 2000);
    }

    private void verifyBuffer(byte[] buffer, int expectedLength) {
        Assert.assertNotNull((Object)buffer);
        Assert.assertEquals((int)buffer.length, (int)expectedLength);
    }
}

