/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.orc.writer.DictionaryRowGroupBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import io.airlift.slice.SizeOf;
import java.util.Arrays;
import java.util.Random;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDictionaryRowGroupBuilder {
    private static final int MAX_DICTIONARY_INDEX = 10000;
    private static final int NULL_INDEX_ENTRY = -1;
    private final Random random = new Random();

    @Test
    public void testEmptyDictionary() {
        DictionaryRowGroupBuilder rowGroupBuilder = new DictionaryRowGroupBuilder();
        rowGroupBuilder.addIndexes(-1, new int[0], 0);
        byte[] byteIndexes = this.getByteIndexes(rowGroupBuilder);
        Assert.assertEquals((int)0, (int)byteIndexes.length);
    }

    @Test
    public void testByteIndexes() {
        int[] dictionaryIndexes = this.createIndexArray(128, 10000);
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)0, (Object)10, (Object)dictionaryIndexes.length).iterator();
        while (unmodifiableIterator.hasNext()) {
            int length = (Integer)unmodifiableIterator.next();
            DictionaryRowGroupBuilder rowGroupBuilder = new DictionaryRowGroupBuilder();
            rowGroupBuilder.addIndexes(127, dictionaryIndexes, length);
            byte[] byteIndexes = this.getByteIndexes(rowGroupBuilder);
            Assert.assertEquals((int)length, (int)byteIndexes.length);
            for (int i = 0; i < length; ++i) {
                Assert.assertEquals((int)dictionaryIndexes[i], (int)byteIndexes[i]);
            }
        }
    }

    @Test
    public void testShortIndexes() {
        int[] dictionaryIndexes = this.createIndexArray(32768, 10000);
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)0, (Object)10, (Object)dictionaryIndexes.length).iterator();
        while (unmodifiableIterator.hasNext()) {
            int length = (Integer)unmodifiableIterator.next();
            DictionaryRowGroupBuilder rowGroupBuilder = new DictionaryRowGroupBuilder();
            rowGroupBuilder.addIndexes(Short.MAX_VALUE, dictionaryIndexes, length);
            short[] shortIndexes = this.getShortIndexes(rowGroupBuilder);
            Assert.assertEquals((int)length, (int)shortIndexes.length);
            for (int i = 0; i < length; ++i) {
                Assert.assertEquals((int)dictionaryIndexes[i], (int)shortIndexes[i]);
            }
        }
    }

    @Test
    public void testIntegerIndexes() {
        int[] dictionaryIndexes = this.createIndexArray(Integer.MAX_VALUE, 10000);
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)0, (Object)10, (Object)dictionaryIndexes.length).iterator();
        while (unmodifiableIterator.hasNext()) {
            int length = (Integer)unmodifiableIterator.next();
            DictionaryRowGroupBuilder rowGroupBuilder = new DictionaryRowGroupBuilder();
            rowGroupBuilder.addIndexes(Integer.MAX_VALUE, dictionaryIndexes, length);
            int[] intIndexes = this.getIntegerIndexes(rowGroupBuilder);
            Assert.assertEquals((int)length, (int)intIndexes.length);
            for (int i = 0; i < length; ++i) {
                Assert.assertEquals((int)dictionaryIndexes[i], (int)intIndexes[i]);
            }
        }
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testDecreasingMaxThrows() {
        DictionaryRowGroupBuilder rowGroupBuilder = new DictionaryRowGroupBuilder();
        rowGroupBuilder.addIndexes(5, new int[0], 0);
        rowGroupBuilder.addIndexes(3, new int[1], 1);
    }

    @Test
    public void testNullDictionary() {
        int[] indexes = new int[10000];
        Arrays.fill(indexes, -1);
        DictionaryRowGroupBuilder rowGroupBuilder = new DictionaryRowGroupBuilder();
        rowGroupBuilder.addIndexes(-1, indexes, indexes.length);
        byte[] byteIndexes = this.getByteIndexes(rowGroupBuilder);
        this.compareIntAndByteArrays(indexes, byteIndexes);
        rowGroupBuilder.addIndexes(-1, indexes, 0);
        byteIndexes = this.getByteIndexes(rowGroupBuilder);
        this.compareIntAndByteArrays(indexes, byteIndexes);
    }

    @Test
    public void testMultipleSegments() {
        int byteSegmentLength = 7;
        int shortSegmentLength = 6;
        int intSegmentLength = 17;
        int[][] segments = new int[byteSegmentLength + shortSegmentLength + intSegmentLength][];
        DictionaryRowGroupBuilder rowGroupBuilder = new DictionaryRowGroupBuilder();
        long emptyRetainedSizeInBytes = rowGroupBuilder.getRetainedSizeInBytes();
        int index = 0;
        int i = 0;
        while (i < byteSegmentLength) {
            segments[index] = this.createIndexArray(128, 1000 + i * 5);
            rowGroupBuilder.addIndexes(127, segments[index], 1000 + i * 3);
            ++i;
            ++index;
        }
        i = 0;
        while (i < shortSegmentLength) {
            segments[index] = this.createIndexArray(32768, 1000 + i * 5);
            rowGroupBuilder.addIndexes(Short.MAX_VALUE, segments[index], 1000 + i * 3);
            ++i;
            ++index;
        }
        i = 0;
        while (i < intSegmentLength) {
            segments[index] = this.createIndexArray(Integer.MAX_VALUE, 1000 + i * 5);
            rowGroupBuilder.addIndexes(Integer.MAX_VALUE, segments[index], 1000 + i * 3);
            ++i;
            ++index;
        }
        byte[][] byteSegments = rowGroupBuilder.getByteSegments();
        short[][] shortSegments = rowGroupBuilder.getShortSegments();
        int[][] intSegments = rowGroupBuilder.getIntegerSegments();
        long indexSize = this.verifySegments(byteSegmentLength, shortSegmentLength, intSegmentLength, segments, byteSegments, shortSegments, intSegments);
        Assert.assertEquals((long)indexSize, (long)rowGroupBuilder.getIndexRetainedBytes());
        long retainedBytesBeforeReset = rowGroupBuilder.getRetainedSizeInBytes();
        rowGroupBuilder.reset();
        Assert.assertEquals((int)0, (int)rowGroupBuilder.getIndexRetainedBytes());
        Assert.assertNull((Object)rowGroupBuilder.getByteSegments());
        Assert.assertNull((Object)rowGroupBuilder.getShortSegments());
        Assert.assertNull((Object)rowGroupBuilder.getIntegerSegments());
        long retainedBytesAfterReset = rowGroupBuilder.getRetainedSizeInBytes();
        Assertions.assertLessThan((Comparable)Long.valueOf(retainedBytesAfterReset), (Comparable)Long.valueOf(retainedBytesBeforeReset));
        Assert.assertEquals((long)emptyRetainedSizeInBytes, (long)retainedBytesAfterReset);
    }

    private void compareIntAndByteArrays(int[] indexes, byte[] byteIndexes) {
        Assert.assertEquals((int)indexes.length, (int)byteIndexes.length);
        for (int i = 0; i < byteIndexes.length; ++i) {
            Assert.assertEquals((int)indexes[i], (int)byteIndexes[i]);
        }
    }

    private int[] createIndexArray(int maxValue, int length) {
        int[] dictionaryIndexes = new int[length];
        for (int i = 0; i < length; ++i) {
            dictionaryIndexes[i] = this.random.nextBoolean() ? -1 : this.random.nextInt(maxValue);
        }
        return dictionaryIndexes;
    }

    private byte[] getByteIndexes(DictionaryRowGroupBuilder rowGroupBuilder) {
        byte[][] byteSegments = rowGroupBuilder.getByteSegments();
        Assert.assertNotNull((Object)byteSegments);
        Assert.assertEquals((int)1, (int)byteSegments.length);
        Assert.assertNull((Object)rowGroupBuilder.getShortSegments());
        Assert.assertNull((Object)rowGroupBuilder.getIntegerSegments());
        Assert.assertNotNull((Object)byteSegments[0]);
        return byteSegments[0];
    }

    private short[] getShortIndexes(DictionaryRowGroupBuilder rowGroupBuilder) {
        short[][] shortSegments = rowGroupBuilder.getShortSegments();
        Assert.assertNotNull((Object)shortSegments);
        Assert.assertEquals((int)1, (int)shortSegments.length);
        Assert.assertNull((Object)rowGroupBuilder.getByteSegments());
        Assert.assertNull((Object)rowGroupBuilder.getIntegerSegments());
        Assert.assertNotNull((Object)shortSegments[0]);
        return shortSegments[0];
    }

    private int[] getIntegerIndexes(DictionaryRowGroupBuilder rowGroupBuilder) {
        int[][] integerSegments = rowGroupBuilder.getIntegerSegments();
        Assert.assertNotNull((Object)integerSegments);
        Assert.assertEquals((int)1, (int)integerSegments.length);
        Assert.assertNull((Object)rowGroupBuilder.getByteSegments());
        Assert.assertNull((Object)rowGroupBuilder.getShortSegments());
        Assert.assertNotNull((Object)integerSegments[0]);
        return integerSegments[0];
    }

    private long verifySegments(int byteSegmentLength, int shortSegmentLength, int intSegmentLength, int[][] segments, byte[][] byteSegments, short[][] shortSegments, int[][] intSegments) {
        int j;
        int index = 0;
        long totalSize = 0L;
        Assert.assertEquals((int)byteSegmentLength, (int)byteSegments.length);
        int i = 0;
        while (i < byteSegments.length) {
            Assert.assertEquals((int)(1000 + i * 3), (int)byteSegments[i].length);
            totalSize += SizeOf.sizeOf((byte[])byteSegments[i]);
            for (j = 0; j < byteSegments[i].length; ++j) {
                Assert.assertEquals((int)segments[index][j], (int)byteSegments[i][j]);
            }
            ++i;
            ++index;
        }
        Assert.assertEquals((int)shortSegmentLength, (int)shortSegments.length);
        i = 0;
        while (i < shortSegments.length) {
            Assert.assertEquals((int)(1000 + i * 3), (int)shortSegments[i].length);
            totalSize += SizeOf.sizeOf((short[])shortSegments[i]);
            for (j = 0; j < shortSegments[i].length; ++j) {
                Assert.assertEquals((int)segments[index][j], (int)shortSegments[i][j]);
            }
            ++i;
            ++index;
        }
        Assert.assertEquals((int)intSegmentLength, (int)intSegments.length);
        i = 0;
        while (i < intSegments.length) {
            Assert.assertEquals((int)(1000 + i * 3), (int)intSegments[i].length);
            totalSize += SizeOf.sizeOf((int[])intSegments[i]);
            for (j = 0; j < intSegments[i].length; ++j) {
                Assert.assertEquals((int)segments[index][j], (int)intSegments[i][j]);
            }
            ++i;
            ++index;
        }
        return totalSize;
    }
}

