/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.orc.writer.LongDictionaryBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLongDictionaryBuilder {
    @Test
    public void testHashCollision() {
        LongDictionaryCollisionBuilder builder = new LongDictionaryCollisionBuilder();
        Assert.assertEquals((int)builder.putIfAbsent(100L), (int)0);
        Assert.assertEquals((int)builder.putIfAbsent(200L), (int)1);
        Assert.assertEquals((int)builder.putIfAbsent(100L), (int)0);
        Assert.assertEquals((int)builder.putIfAbsent(200L), (int)1);
        Assert.assertEquals((int)builder.size(), (int)2);
    }

    @Test
    public void testBuilder() {
        LongDictionaryBuilder builder = new LongDictionaryBuilder(1000);
        int startElement = -50000;
        int totalElements = 100000;
        for (int attempt = 0; attempt < 3; ++attempt) {
            for (int i = 0; i < totalElements; ++i) {
                long value = startElement + i;
                for (int j = 0; j < 3; ++j) {
                    Assert.assertEquals((int)builder.putIfAbsent(value), (int)i);
                }
                Assert.assertEquals((int)builder.size(), (int)(i + 1));
                Assert.assertEquals((long)builder.getValue(i), (long)value);
            }
            long[] elements = builder.elements();
            for (int i = 0; i < totalElements; ++i) {
                Assert.assertEquals((long)elements[i], (long)(startElement + i));
            }
            long minExpectedSize = totalElements * 12;
            Assert.assertTrue((builder.getRetainedBytes() > minExpectedSize ? 1 : 0) != 0, (String)("retainedBytes " + builder.getRetainedBytes()));
            builder.clear();
            Assert.assertEquals((int)builder.size(), (int)0);
        }
    }

    @Test
    public void testRandomLongs() {
        int i;
        LongDictionaryBuilder builder = new LongDictionaryBuilder(1000);
        long seed = System.currentTimeMillis() / 10000000L;
        Random random = new Random(seed);
        HashSet<Long> uniqueValues = new HashSet<Long>();
        for (int i2 = 0; i2 < 100000; ++i2) {
            uniqueValues.add(random.nextLong());
        }
        ArrayList values = new ArrayList(uniqueValues);
        for (i = 0; i < values.size(); ++i) {
            Assert.assertEquals((int)builder.putIfAbsent(((Long)values.get(i)).longValue()), (int)i);
        }
        for (i = 0; i < 500000; ++i) {
            int nextIndex = random.nextInt(values.size());
            Assert.assertEquals((int)builder.putIfAbsent(((Long)values.get(nextIndex)).longValue()), (int)nextIndex);
        }
        Assert.assertEquals((int)builder.size(), (int)values.size());
    }

    private static class LongDictionaryCollisionBuilder
    extends LongDictionaryBuilder {
        LongDictionaryCollisionBuilder() {
            super(10000);
        }

        public long getHash(long value) {
            return 0L;
        }
    }
}

