/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.common.block.AbstractVariableWidthBlockBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.VariableWidthBlockBuilder;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.writer.SegmentedSliceBlockBuilder;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSegmentedSliceBlockBuilder {
    private static final Slice SLICE = Slices.utf8Slice((String)"abcdefghijklmnopqrstuvwxyz");

    @Test
    public void testBasicOperations() {
        SegmentedSliceBlockBuilder blockBuilder = new SegmentedSliceBlockBuilder(10, 10);
        long retainedSize = this.addElementsToBlockBuilder(blockBuilder);
        blockBuilder.reset();
        Assert.assertEquals((long)blockBuilder.getSizeInBytes(), (long)0L);
        Assertions.assertLessThan((Comparable)Long.valueOf(blockBuilder.getRetainedSizeInBytes()), (Comparable)Long.valueOf(retainedSize));
        this.addElementsToBlockBuilder(blockBuilder);
        int index = 0;
        for (int j = 0; j < 100000; ++j) {
            for (int i = 0; i < SLICE.length(); ++i) {
                Slice rawSlice = blockBuilder.getRawSlice(index);
                int offset = blockBuilder.getPositionOffset(index);
                int length = blockBuilder.getSliceLength(index);
                ++index;
                Assert.assertEquals((int)length, (int)1);
                Assert.assertTrue((boolean)SLICE.equals(i, 1, rawSlice, offset, length));
            }
        }
    }

    @Test
    public void testEqualsAndHashCode() {
        SegmentedSliceBlockBuilder blockBuilder = new SegmentedSliceBlockBuilder(10, 10);
        VariableWidthBlockBuilder variableBlockBuilder = new VariableWidthBlockBuilder(null, 10, 10);
        for (int i = 0; i < SLICE.length(); ++i) {
            blockBuilder.writeBytes(SLICE, i, 1);
            blockBuilder.closeEntry();
            variableBlockBuilder.writeBytes(SLICE, i, 1);
            variableBlockBuilder.closeEntry();
        }
        Block block = variableBlockBuilder.build();
        for (int i = 0; i < SLICE.length(); ++i) {
            Assert.assertTrue((boolean)blockBuilder.equals(i, block, i, 1));
            Assert.assertTrue((boolean)blockBuilder.equals(i, 0, block, i, 0, 1));
            Assert.assertEquals((long)blockBuilder.hash(i), (long)variableBlockBuilder.hash(i, 0, 1));
        }
    }

    @Test
    public void testCompareTo() {
        int i;
        SegmentedSliceBlockBuilder blockBuilder = new SegmentedSliceBlockBuilder(10, 10);
        for (i = 0; i < SLICE.length(); ++i) {
            blockBuilder.writeBytes(SLICE, i, 1);
            blockBuilder.closeEntry();
        }
        for (i = 0; i < SLICE.length() - 1; ++i) {
            Assertions.assertLessThan((Comparable)Integer.valueOf(blockBuilder.compareTo(i, i + 1)), (Comparable)Integer.valueOf(0));
            Assert.assertEquals((int)blockBuilder.compareTo(i, i), (int)0);
            Assertions.assertGreaterThan((Comparable)Integer.valueOf(blockBuilder.compareTo(i + 1, i)), (Comparable)Integer.valueOf(0));
        }
    }

    @Test
    public void testWriteBytes() {
        int entries = 100;
        String inputChars = "abcdefghijklmnopqrstuvwwxyz01234566789!@#$%^";
        SegmentedSliceBlockBuilder blockBuilder = new SegmentedSliceBlockBuilder(entries, inputChars.length());
        ArrayList<String> values = new ArrayList<String>();
        Random rand = new Random(0L);
        byte[] bytes = inputChars.getBytes(StandardCharsets.UTF_8);
        Assert.assertEquals((int)bytes.length, (int)inputChars.length());
        for (int i = 0; i < entries; ++i) {
            int valueLength = rand.nextInt(bytes.length);
            VarcharType.VARCHAR.writeBytes((AbstractVariableWidthBlockBuilder)blockBuilder, bytes, 0, valueLength);
            values.add(inputChars.substring(0, valueLength));
        }
        this.verifyBlockValues((Block)blockBuilder, values);
    }

    private void verifyBlockValues(Block block, List<String> values) {
        Assert.assertEquals((int)block.getPositionCount(), (int)values.size());
        for (int i = 0; i < block.getPositionCount(); ++i) {
            Slice slice = VarcharType.VARCHAR.getSlice(block, i);
            Assert.assertEquals((Object)slice, (Object)Slices.utf8Slice((String)values.get(i)));
        }
    }

    private long addElementsToBlockBuilder(SegmentedSliceBlockBuilder blockBuilder) {
        int size = 1;
        long retainedSize = blockBuilder.getRetainedSizeInBytes();
        int lastOpenSegmentIndex = blockBuilder.getOpenSegmentIndex();
        for (int j = 0; j < 100000; ++j) {
            for (int i = 0; i < SLICE.length(); ++i) {
                blockBuilder.writeBytes(SLICE, i, 1);
                blockBuilder.closeEntry();
                Assert.assertEquals((int)blockBuilder.getPositionCount(), (int)size++);
                Slice rawSlice = blockBuilder.getRawSlice(blockBuilder.getPositionCount() - 1);
                int offset = blockBuilder.getPositionOffset(blockBuilder.getPositionCount() - 1);
                int length = blockBuilder.getSliceLength(blockBuilder.getPositionCount() - 1);
                Assert.assertEquals((int)length, (int)1);
                Assert.assertTrue((boolean)SLICE.equals(i, 1, rawSlice, offset, length));
            }
            Assert.assertEquals((long)blockBuilder.getSizeInBytes(), (long)((long)blockBuilder.getPositionCount() * 5L));
            if (blockBuilder.getOpenSegmentIndex() > lastOpenSegmentIndex) {
                Assertions.assertGreaterThan((Comparable)Long.valueOf(blockBuilder.getRetainedSizeInBytes()), (Comparable)Long.valueOf(retainedSize));
            }
            Assertions.assertGreaterThanOrEqual((Comparable)Long.valueOf(blockBuilder.getRetainedSizeInBytes()), (Comparable)Long.valueOf(retainedSize));
            retainedSize = blockBuilder.getRetainedSizeInBytes();
            lastOpenSegmentIndex = blockBuilder.getOpenSegmentIndex();
        }
        return retainedSize;
    }
}

