/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.VariableWidthBlock;
import com.facebook.presto.orc.writer.SliceDictionaryBuilder;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSliceDictionaryBuilder {
    @Test
    public void testBlockWithHashCollision() {
        Slice slice1 = Slices.wrappedBuffer((byte[])new byte[]{1});
        Slice slice2 = Slices.wrappedBuffer((byte[])new byte[]{2});
        SliceDictionaryBuilder sliceDictionaryBuilder = new SliceDictionaryBuilder(64);
        for (int i = 0; i < 64; ++i) {
            int dictionaryIndex = sliceDictionaryBuilder.putIfAbsent((Block)new TestHashCollisionBlock(1, slice1, new int[]{0, 1}, new boolean[]{false}), 0);
            Assert.assertEquals((int)dictionaryIndex, (int)0);
            dictionaryIndex = sliceDictionaryBuilder.putIfAbsent((Block)new TestHashCollisionBlock(1, slice2, new int[]{0, 1}, new boolean[]{false}), 0);
            Assert.assertEquals((int)dictionaryIndex, (int)1);
        }
        Assert.assertEquals((int)sliceDictionaryBuilder.getEntryCount(), (int)2);
        this.validatePosition(sliceDictionaryBuilder, 0, 0, slice1);
        this.validatePosition(sliceDictionaryBuilder, 1, 1, slice2);
    }

    private void validatePosition(SliceDictionaryBuilder sliceDictionaryBuilder, int position, int expectedOffset, Slice expectedSlice) {
        int length = expectedSlice.length();
        Assert.assertEquals((int)sliceDictionaryBuilder.getRawSliceOffset(position), (int)expectedOffset);
        Assert.assertEquals((int)sliceDictionaryBuilder.getSliceLength(position), (int)length);
        Assert.assertEquals((Object)sliceDictionaryBuilder.getSlice(position, length), (Object)expectedSlice);
        Slice rawSlice = sliceDictionaryBuilder.getRawSlice(position);
        Assert.assertEquals((Object)Slices.copyOf((Slice)rawSlice, (int)expectedOffset, (int)length), (Object)expectedSlice);
    }

    private static class TestHashCollisionBlock
    extends VariableWidthBlock {
        public TestHashCollisionBlock(int positionCount, Slice slice, int[] offsets, boolean[] valueIsNull) {
            super(positionCount, slice, offsets, Optional.of(valueIsNull));
        }

        public long hash(int position, int offset, int length) {
            return 0L;
        }
    }
}

