/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcDecompressor;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.TestingHiveOrcAggregatedMemoryContext;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.ByteArrayInputStream;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.LongInputStreamV1;
import com.facebook.presto.orc.stream.LongInputStreamV2;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.SharedBuffer;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.writer.DictionaryColumnWriter;
import com.facebook.presto.orc.writer.SliceDictionaryColumnWriter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreCollectors;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSliceDictionaryColumnWriter {
    private static final int COLUMN_ID = 1;
    private static final OrcDataSourceId ORC_DATA_SOURCE_ID = new OrcDataSourceId("test");

    private StreamDataOutput getStreamKind(List<StreamDataOutput> streams, Stream.StreamKind streamKind) {
        return (StreamDataOutput)streams.stream().filter(e -> e.getStream().getStreamKind() == streamKind).collect(MoreCollectors.onlyElement());
    }

    private Optional<OrcDecompressor> getOrcDecompressor() {
        int compressionBlockSize = Math.toIntExact(new DataSize(256.0, DataSize.Unit.KILOBYTE).toBytes());
        return OrcDecompressor.createOrcDecompressor((OrcDataSourceId)ORC_DATA_SOURCE_ID, (CompressionKind)CompressionKind.SNAPPY, (int)compressionBlockSize);
    }

    private OrcInputStream convertSliceToInputStream(Slice slice) {
        TestingHiveOrcAggregatedMemoryContext aggregatedMemoryContext = new TestingHiveOrcAggregatedMemoryContext();
        return new OrcInputStream(ORC_DATA_SOURCE_ID, new SharedBuffer(aggregatedMemoryContext.newOrcLocalMemoryContext("sharedDecompressionBuffer")), (FixedLengthSliceInput)slice.getInput(), this.getOrcDecompressor(), Optional.empty(), (OrcAggregatedMemoryContext)aggregatedMemoryContext, slice.getRetainedSize());
    }

    private Slice convertStreamToSlice(StreamDataOutput streamDataOutput) throws OrcCorruptionException {
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(Math.toIntExact(streamDataOutput.size()));
        streamDataOutput.writeData((SliceOutput)sliceOutput);
        return sliceOutput.slice();
    }

    private OrcInputStream getOrcInputStream(List<StreamDataOutput> streams, Stream.StreamKind streamKind) throws OrcCorruptionException {
        StreamDataOutput stream = this.getStreamKind(streams, streamKind);
        Slice slice = this.convertStreamToSlice(stream);
        return this.convertSliceToInputStream(slice);
    }

    private LongInputStream getDictionaryLengthStream(List<StreamDataOutput> streams, OrcEncoding orcEncoding) {
        if (orcEncoding == OrcEncoding.DWRF) {
            return new LongInputStreamV1(this.getOrcInputStream(streams, Stream.StreamKind.LENGTH), false);
        }
        return new LongInputStreamV2(this.getOrcInputStream(streams, Stream.StreamKind.LENGTH), false, false);
    }

    private List<String> getDictionaryKeys(List<String> values, OrcEncoding orcEncoding, boolean sortDictionaryKeys) throws IOException {
        DictionaryColumnWriter writer = this.getDictionaryColumnWriter(orcEncoding, sortDictionaryKeys);
        int index = 0;
        while (index < values.size()) {
            int endIndex = Math.min(index + 10000, values.size());
            BlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 10000);
            while (index < endIndex) {
                VarcharType.VARCHAR.writeSlice(blockBuilder, Slices.utf8Slice((String)values.get(index++)));
            }
            writer.beginRowGroup();
            writer.writeBlock((Block)blockBuilder);
            writer.finishRowGroup();
        }
        writer.close();
        List streams = writer.getDataStreams();
        int dictionarySize = ((ColumnEncoding)writer.getColumnEncodings().get(1)).getDictionarySize();
        ByteArrayInputStream dictionaryDataStream = new ByteArrayInputStream(this.getOrcInputStream(streams, Stream.StreamKind.DICTIONARY_DATA));
        LongInputStream dictionaryLengthStream = this.getDictionaryLengthStream(streams, orcEncoding);
        ArrayList<String> dictionaryKeys = new ArrayList<String>(dictionarySize);
        for (int i = 0; i < dictionarySize; ++i) {
            int length = Math.toIntExact(dictionaryLengthStream.next());
            String dictionaryKey = new String(dictionaryDataStream.next(length), StandardCharsets.UTF_8);
            dictionaryKeys.add(dictionaryKey);
        }
        return dictionaryKeys;
    }

    private DictionaryColumnWriter getDictionaryColumnWriter(OrcEncoding orcEncoding, boolean sortDictionaryKeys) {
        ColumnWriterOptions columnWriterOptions = ColumnWriterOptions.builder().setCompressionKind(CompressionKind.SNAPPY).setStringDictionarySortingEnabled(sortDictionaryKeys).build();
        SliceDictionaryColumnWriter writer = new SliceDictionaryColumnWriter(1, 0, (Type)VarcharType.VARCHAR, columnWriterOptions, Optional.empty(), orcEncoding, orcEncoding.createMetadataWriter());
        return writer;
    }

    @Test
    public void testSortedDictionaryKeys() throws IOException {
        for (OrcEncoding orcEncoding : OrcEncoding.values()) {
            List<String> sortedKeys = this.getDictionaryKeys((List<String>)ImmutableList.of((Object)"b", (Object)"a", (Object)"c"), orcEncoding, true);
            Assert.assertEquals(sortedKeys, (Collection)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
            sortedKeys = this.getDictionaryKeys((List<String>)ImmutableList.of((Object)"b", (Object)"b", (Object)"a"), orcEncoding, true);
            Assert.assertEquals(sortedKeys, (Collection)ImmutableList.of((Object)"a", (Object)"b"));
        }
    }

    @Test
    public void testUnsortedDictionaryKeys() throws IOException {
        List<String> sortedKeys = this.getDictionaryKeys((List<String>)ImmutableList.of((Object)"b", (Object)"a", (Object)"c"), OrcEncoding.DWRF, false);
        Assert.assertEquals(sortedKeys, (Collection)ImmutableList.of((Object)"b", (Object)"a", (Object)"c"));
        sortedKeys = this.getDictionaryKeys((List<String>)ImmutableList.of((Object)"b", (Object)"b", (Object)"a"), OrcEncoding.DWRF, false);
        Assert.assertEquals(sortedKeys, (Collection)ImmutableList.of((Object)"b", (Object)"a"));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testOrcStringSortingDisabledThrows() {
        this.getDictionaryColumnWriter(OrcEncoding.ORC, false);
    }

    @Test
    public void testStringDirectConversion() {
        byte[] value = new byte[TestSliceDictionaryColumnWriter.megabytes(1)];
        ThreadLocalRandom.current().nextBytes(value);
        Block data = RunLengthEncodedBlock.create((Type)VarcharType.VARCHAR, (Object)Slices.wrappedBuffer((byte[])value), (int)3000);
        for (OrcEncoding orcEncoding : OrcEncoding.values()) {
            DictionaryColumnWriter writer = this.getDictionaryColumnWriter(orcEncoding, true);
            writer.beginRowGroup();
            writer.writeBlock(data);
            writer.finishRowGroup();
            Assert.assertFalse((boolean)writer.tryConvertToDirect(TestSliceDictionaryColumnWriter.megabytes(64)).isPresent());
        }
    }

    private static int megabytes(int size) {
        return Math.toIntExact(new DataSize((double)size, DataSize.Unit.MEGABYTE).toBytes());
    }
}

