/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.RowBlock;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.FixedWidthType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.DefaultOrcWriterFlushPolicy;
import com.facebook.presto.orc.DwrfEncryptionInfo;
import com.facebook.presto.orc.FileOrcDataSource;
import com.facebook.presto.orc.NoOpOrcWriterStats;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.OrcWriter;
import com.facebook.presto.orc.OrcWriterFlushPolicy;
import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.orc.TempFile;
import com.facebook.presto.orc.TestOrcMapNullKey;
import com.facebook.presto.orc.WriterStats;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.facebook.presto.orc.writer.ColumnWriters;
import com.facebook.presto.orc.writer.DictionaryColumnWriter;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestWriterBlockRawSize {
    private static final int NUM_ELEMENTS = 100;
    private static final int COLUMN_INDEX = 1;
    private static final ColumnWriterOptions COLUMN_WRITER_OPTIONS = ColumnWriterOptions.builder().setCompressionKind(CompressionKind.ZSTD).setCompressionMaxBufferSize(new DataSize(256.0, DataSize.Unit.KILOBYTE)).setIntegerDictionaryEncodingEnabled(true).build();

    private static ColumnWriter createColumnWriter(Type type) {
        List orcTypes = OrcType.createOrcRowType((int)0, (List)ImmutableList.of((Object)"test_size_col"), (List)ImmutableList.of((Object)type));
        ColumnWriter columnWriter = ColumnWriters.createColumnWriter((int)1, (int)0, (List)orcTypes, (Type)type, (ColumnWriterOptions)COLUMN_WRITER_OPTIONS, (OrcEncoding)OrcEncoding.DWRF, (DateTimeZone)OrcTester.HIVE_STORAGE_TIME_ZONE, (DwrfEncryptionInfo)DwrfEncryptionInfo.UNENCRYPTED, (MetadataWriter)OrcEncoding.DWRF.createMetadataWriter());
        columnWriter.beginRowGroup();
        return columnWriter;
    }

    @DataProvider(name="IntegerTypes")
    public Object[][] integerTypesProvider() {
        return new Object[][]{{TinyintType.TINYINT}, {SmallintType.SMALLINT}, {IntegerType.INTEGER}, {BigintType.BIGINT}};
    }

    @DataProvider(name="StringTypes")
    public Object[][] stringTypesProvider() {
        return new Object[][]{{VarbinaryType.VARBINARY}, {VarcharType.VARCHAR}};
    }

    @DataProvider(name="FractionalTypes")
    public Object[][] fractionalTypesProvider() {
        return new Object[][]{{RealType.REAL}, {DoubleType.DOUBLE}};
    }

    @Test(dataProvider="IntegerTypes")
    public void testIntegerWriter(Type type) {
        BlockBuilder blockBuilder = type.createBlockBuilder(null, 200);
        for (int i = 0; i < 100; ++i) {
            blockBuilder.appendNull();
            type.writeLong(blockBuilder, (long)i);
        }
        Block block = blockBuilder.build();
        ColumnWriter columnWriter = TestWriterBlockRawSize.createColumnWriter(type);
        long rawSize = columnWriter.writeBlock(block);
        long expectedSize = 100 * (1 + ((FixedWidthType)type).getFixedSize());
        Assert.assertEquals((long)rawSize, (long)expectedSize);
        this.verifyDictionaryColumnWriter(expectedSize, block, columnWriter);
    }

    @Test(dataProvider="StringTypes")
    public void testStringType(Type type) {
        BlockBuilder blockBuilder = type.createBlockBuilder(null, 200);
        long expectedSize = 0L;
        for (int i = 0; i < 100; ++i) {
            blockBuilder.appendNull();
            String value = Integer.toString(i);
            type.writeSlice(blockBuilder, Slices.utf8Slice((String)value));
            expectedSize += (long)(1 + value.length());
        }
        Block block = blockBuilder.build();
        ColumnWriter columnWriter = TestWriterBlockRawSize.createColumnWriter(type);
        long rawSize = columnWriter.writeBlock(block);
        Assert.assertEquals((long)rawSize, (long)expectedSize);
        this.verifyDictionaryColumnWriter(expectedSize, block, columnWriter);
    }

    private void verifyDictionaryColumnWriter(long expectedSize, Block block, ColumnWriter columnWriter) {
        if (columnWriter instanceof DictionaryColumnWriter) {
            DictionaryColumnWriter dictionaryColumnWriter = (DictionaryColumnWriter)columnWriter;
            OptionalInt convertToDirect = dictionaryColumnWriter.tryConvertToDirect(Integer.MAX_VALUE);
            Assert.assertTrue((boolean)convertToDirect.isPresent());
            long rawSize = dictionaryColumnWriter.writeBlock(block);
            Assert.assertEquals((long)rawSize, (long)expectedSize);
        }
    }

    @Test
    public void testBooleanWriter() {
        ColumnWriter columnWriter = TestWriterBlockRawSize.createColumnWriter((Type)BooleanType.BOOLEAN);
        BlockBuilder blockBuilder = BooleanType.BOOLEAN.createBlockBuilder(null, 200);
        for (int i = 0; i < 100; ++i) {
            blockBuilder.appendNull();
            BooleanType.BOOLEAN.writeBoolean(blockBuilder, i % 2 == 0);
        }
        long rawSize = columnWriter.writeBlock(blockBuilder.build());
        long expectedSize = 200L;
        Assert.assertEquals((long)rawSize, (long)expectedSize);
    }

    @Test(dataProvider="FractionalTypes")
    public void testFractionalTypes(Type type) {
        ColumnWriter columnWriter = TestWriterBlockRawSize.createColumnWriter(type);
        BlockBuilder blockBuilder = type.createBlockBuilder(null, 200);
        for (int i = 0; i < 100; ++i) {
            blockBuilder.appendNull();
            if (type == RealType.REAL) {
                type.writeLong(blockBuilder, (long)Float.floatToIntBits(i));
                continue;
            }
            type.writeDouble(blockBuilder, (double)i);
        }
        long rawSize = columnWriter.writeBlock(blockBuilder.build());
        long expectedSize = 100 * (1 + ((FixedWidthType)type).getFixedSize());
        Assert.assertEquals((long)rawSize, (long)expectedSize);
    }

    @Test
    public void testArrayType() {
        IntegerType elementType = IntegerType.INTEGER;
        ArrayType arrayType = new ArrayType((Type)elementType);
        ColumnWriter columnWriter = TestWriterBlockRawSize.createColumnWriter((Type)arrayType);
        BlockBuilder blockBuilder = arrayType.createBlockBuilder(null, 200);
        int totalChildElements = 0;
        for (int i = 0; i < 100; ++i) {
            blockBuilder.appendNull();
            BlockBuilder elementBlockBuilder = blockBuilder.beginBlockEntry();
            for (int j = 0; j < i; ++j) {
                elementType.writeLong(elementBlockBuilder, (long)j);
            }
            blockBuilder.closeEntry();
            totalChildElements += i;
        }
        long rawSize = columnWriter.writeBlock(blockBuilder.build());
        long expectedSize = 100 + totalChildElements * ((FixedWidthType)elementType).getFixedSize();
        Assert.assertEquals((long)rawSize, (long)expectedSize);
    }

    @Test
    public void testMapType() {
        IntegerType elementType = IntegerType.INTEGER;
        MapType arrayType = TestOrcMapNullKey.createMapType((Type)elementType, (Type)elementType);
        ColumnWriter columnWriter = TestWriterBlockRawSize.createColumnWriter((Type)arrayType);
        BlockBuilder blockBuilder = arrayType.createBlockBuilder(null, 200);
        int totalChildElements = 0;
        for (int i = 0; i < 100; ++i) {
            blockBuilder.appendNull();
            BlockBuilder elementBlockBuilder = blockBuilder.beginBlockEntry();
            for (int j = 0; j < i; ++j) {
                elementType.writeLong(elementBlockBuilder, (long)j);
                elementType.writeLong(elementBlockBuilder, (long)j);
            }
            blockBuilder.closeEntry();
            totalChildElements += i;
        }
        long rawSize = columnWriter.writeBlock(blockBuilder.build());
        long expectedSize = 100 + totalChildElements * 2 * ((FixedWidthType)elementType).getFixedSize();
        Assert.assertEquals((long)rawSize, (long)expectedSize);
    }

    @Test
    public void testRowType() {
        IntegerType elementType = IntegerType.INTEGER;
        RowType rowType = RowType.anonymous((List)ImmutableList.of((Object)elementType, (Object)elementType));
        ColumnWriter columnWriter = TestWriterBlockRawSize.createColumnWriter((Type)rowType);
        BlockBuilder blockBuilder = elementType.createBlockBuilder(null, 100);
        boolean[] isNull = new boolean[200];
        for (int i = 0; i < 100; ++i) {
            elementType.writeLong(blockBuilder, (long)i);
            isNull[i * 2] = true;
        }
        Block elementBlock = blockBuilder.build();
        Block[] elementBlocks = new Block[]{elementBlock, elementBlock};
        Block rowBlock = RowBlock.fromFieldBlocks((int)200, Optional.of(isNull), (Block[])elementBlocks);
        long rawSize = columnWriter.writeBlock(rowBlock);
        long expectedSize = 100 + 200 * ((FixedWidthType)elementType).getFixedSize();
        Assert.assertEquals((long)rawSize, (long)expectedSize);
    }

    @Test
    public void testTimestampType() {
        TimestampType timestampType = TimestampType.TIMESTAMP;
        ColumnWriter columnWriter = TestWriterBlockRawSize.createColumnWriter((Type)timestampType);
        BlockBuilder blockBuilder = timestampType.createBlockBuilder(null, 200);
        for (int i = 0; i < 100; ++i) {
            blockBuilder.appendNull();
            timestampType.writeLong(blockBuilder, (long)i);
        }
        long rawSize = columnWriter.writeBlock(blockBuilder.build());
        long expectedSize = 1300L;
        Assert.assertEquals((long)rawSize, (long)expectedSize);
    }

    @Test
    public void testFileMetadataRawSize() throws IOException {
        IntegerType type = IntegerType.INTEGER;
        ImmutableList types = ImmutableList.of((Object)type);
        int numBlocksPerRowGroup = 3;
        int numBlocksPerStripe = numBlocksPerRowGroup * 5;
        int numStripes = 4;
        int numBlocksPerFile = numBlocksPerStripe * numStripes + 1;
        BlockBuilder blockBuilder = type.createBlockBuilder(null, 200);
        for (int i = 0; i < 100; ++i) {
            blockBuilder.appendNull();
            type.writeLong(blockBuilder, (long)i);
        }
        long blockRawSize = ((FixedWidthType)type).getFixedSize() * 100 + 100;
        Block block = blockBuilder.build();
        Block[] blocks = new Block[]{block};
        OrcWriterOptions writerOptions = OrcWriterOptions.builder().withRowGroupMaxRowCount(block.getPositionCount() * numBlocksPerRowGroup).withFlushPolicy((OrcWriterFlushPolicy)DefaultOrcWriterFlushPolicy.builder().withStripeMaxRowCount(block.getPositionCount() * numBlocksPerStripe).build()).build();
        for (OrcEncoding encoding : OrcEncoding.values()) {
            try (TempFile tempFile = new TempFile();){
                OrcWriter writer = OrcTester.createOrcWriter(tempFile.getFile(), encoding, CompressionKind.ZSTD, Optional.empty(), (List<Type>)types, writerOptions, (WriterStats)NoOpOrcWriterStats.NOOP_WRITER_STATS);
                for (int i = 0; i < numBlocksPerFile; ++i) {
                    writer.write(new Page(blocks));
                }
                writer.close();
                writer.validate((OrcDataSource)new FileOrcDataSource(tempFile.getFile(), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), true));
                Footer footer = OrcTester.getFileMetadata(tempFile.getFile(), encoding).getFooter();
                this.verifyValue(encoding, footer.getRawSize(), blockRawSize * (long)numBlocksPerFile);
                Assert.assertEquals((int)footer.getStripes().size(), (int)(numStripes + 1));
                int numBlocksRemaining = numBlocksPerFile;
                for (StripeInformation stripeInfo : footer.getStripes()) {
                    int numBlocksInStripe = Math.min(numBlocksRemaining, numBlocksPerStripe);
                    this.verifyValue(encoding, stripeInfo.getRawDataSize(), blockRawSize * (long)numBlocksInStripe);
                    numBlocksRemaining -= numBlocksInStripe;
                }
            }
        }
    }

    private void verifyValue(OrcEncoding encoding, OptionalLong actual, long expected) {
        if (OrcEncoding.DWRF == encoding) {
            Assert.assertEquals((Object)actual, (Object)OptionalLong.of(expected));
        } else {
            Assert.assertEquals((Object)actual, (Object)OptionalLong.empty());
        }
    }
}

