/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.cache;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MinDataSize;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;

public class OrcCacheConfig {
    private boolean fileTailCacheEnabled;
    private DataSize fileTailCacheSize = new DataSize(1.0, DataSize.Unit.MEGABYTE);
    private Duration fileTailCacheTtlSinceLastAccess = new Duration(0.0, TimeUnit.SECONDS);
    private boolean stripeMetadataCacheEnabled;
    private DataSize stripeFooterCacheSize = new DataSize(0.0, DataSize.Unit.BYTE);
    private Duration stripeFooterCacheTtlSinceLastAccess = new Duration(0.0, TimeUnit.SECONDS);
    private DataSize stripeStreamCacheSize = new DataSize(0.0, DataSize.Unit.BYTE);
    private Duration stripeStreamCacheTtlSinceLastAccess = new Duration(0.0, TimeUnit.SECONDS);
    private boolean rowGroupIndexCacheEnabled;
    private DataSize rowGroupIndexCacheSize = new DataSize(0.0, DataSize.Unit.BYTE);
    private Duration rowGroupIndexCacheTtlSinceLastAccess = new Duration(0.0, TimeUnit.SECONDS);
    private boolean dwrfStripeCacheEnabled = true;
    private DataSize expectedFileTailSize = new DataSize(16384.0, DataSize.Unit.BYTE);

    public boolean isFileTailCacheEnabled() {
        return this.fileTailCacheEnabled;
    }

    @Config(value="orc.file-tail-cache-enabled")
    @ConfigDescription(value="Enable cache for orc file tail")
    public OrcCacheConfig setFileTailCacheEnabled(boolean fileTailCacheEnabled) {
        this.fileTailCacheEnabled = fileTailCacheEnabled;
        return this;
    }

    @MinDataSize(value="0B")
    public DataSize getFileTailCacheSize() {
        return this.fileTailCacheSize;
    }

    @Config(value="orc.file-tail-cache-size")
    @ConfigDescription(value="Size of the orc file tail cache")
    public OrcCacheConfig setFileTailCacheSize(DataSize fileTailCacheSize) {
        this.fileTailCacheSize = fileTailCacheSize;
        return this;
    }

    @MinDuration(value="0s")
    public Duration getFileTailCacheTtlSinceLastAccess() {
        return this.fileTailCacheTtlSinceLastAccess;
    }

    @Config(value="orc.file-tail-cache-ttl-since-last-access")
    @ConfigDescription(value="Time-to-live for orc file tail cache entry after last access")
    public OrcCacheConfig setFileTailCacheTtlSinceLastAccess(Duration fileTailCacheTtlSinceLastAccess) {
        this.fileTailCacheTtlSinceLastAccess = fileTailCacheTtlSinceLastAccess;
        return this;
    }

    public boolean isStripeMetadataCacheEnabled() {
        return this.stripeMetadataCacheEnabled;
    }

    @Config(value="orc.stripe-metadata-cache-enabled")
    @ConfigDescription(value="Enable cache for stripe metadata")
    public OrcCacheConfig setStripeMetadataCacheEnabled(boolean stripeMetadataCacheEnabled) {
        this.stripeMetadataCacheEnabled = stripeMetadataCacheEnabled;
        return this;
    }

    @MinDataSize(value="0B")
    public DataSize getStripeFooterCacheSize() {
        return this.stripeFooterCacheSize;
    }

    @Config(value="orc.stripe-footer-cache-size")
    @ConfigDescription(value="Size of the stripe footer cache")
    public OrcCacheConfig setStripeFooterCacheSize(DataSize stripeFooterCacheSize) {
        this.stripeFooterCacheSize = stripeFooterCacheSize;
        return this;
    }

    @MinDuration(value="0s")
    public Duration getStripeFooterCacheTtlSinceLastAccess() {
        return this.stripeFooterCacheTtlSinceLastAccess;
    }

    @Config(value="orc.stripe-footer-cache-ttl-since-last-access")
    @ConfigDescription(value="Time-to-live for stripe footer cache entry after last access")
    public OrcCacheConfig setStripeFooterCacheTtlSinceLastAccess(Duration stripeFooterCacheTtlSinceLastAccess) {
        this.stripeFooterCacheTtlSinceLastAccess = stripeFooterCacheTtlSinceLastAccess;
        return this;
    }

    @MinDataSize(value="0B")
    public DataSize getStripeStreamCacheSize() {
        return this.stripeStreamCacheSize;
    }

    @Config(value="orc.stripe-stream-cache-size")
    @ConfigDescription(value="Size of the stripe stream cache")
    public OrcCacheConfig setStripeStreamCacheSize(DataSize stripeStreamCacheSize) {
        this.stripeStreamCacheSize = stripeStreamCacheSize;
        return this;
    }

    @MinDuration(value="0s")
    public Duration getStripeStreamCacheTtlSinceLastAccess() {
        return this.stripeStreamCacheTtlSinceLastAccess;
    }

    @Config(value="orc.stripe-stream-cache-ttl-since-last-access")
    @ConfigDescription(value="Time-to-live for stripe stream cache entry after last access")
    public OrcCacheConfig setStripeStreamCacheTtlSinceLastAccess(Duration stripeStreamCacheTtlSinceLastAccess) {
        this.stripeStreamCacheTtlSinceLastAccess = stripeStreamCacheTtlSinceLastAccess;
        return this;
    }

    public boolean isRowGroupIndexCacheEnabled() {
        return this.rowGroupIndexCacheEnabled;
    }

    @Config(value="orc.row-group-index-cache-enabled")
    public OrcCacheConfig setRowGroupIndexCacheEnabled(boolean rowGroupIndexCacheEnabled) {
        this.rowGroupIndexCacheEnabled = rowGroupIndexCacheEnabled;
        return this;
    }

    @MinDataSize(value="0B")
    public DataSize getRowGroupIndexCacheSize() {
        return this.rowGroupIndexCacheSize;
    }

    @Config(value="orc.row-group-index-cache-size")
    @ConfigDescription(value="Size of the stripe row group index stream cache")
    public OrcCacheConfig setRowGroupIndexCacheSize(DataSize rowGroupIndexCacheSize) {
        this.rowGroupIndexCacheSize = rowGroupIndexCacheSize;
        return this;
    }

    @MinDuration(value="0s")
    public Duration getRowGroupIndexCacheTtlSinceLastAccess() {
        return this.rowGroupIndexCacheTtlSinceLastAccess;
    }

    @Config(value="orc.row-group-index-cache-ttl-since-last-access")
    @ConfigDescription(value="Time-to-live for stripe stream row group index cache entry after last access")
    public OrcCacheConfig setRowGroupIndexCacheTtlSinceLastAccess(Duration rowGroupIndexCacheTtlSinceLastAccess) {
        this.rowGroupIndexCacheTtlSinceLastAccess = rowGroupIndexCacheTtlSinceLastAccess;
        return this;
    }

    public boolean isDwrfStripeCacheEnabled() {
        return this.dwrfStripeCacheEnabled;
    }

    @Config(value="orc.dwrf-stripe-cache-enabled")
    @ConfigDescription(value="Check DWRF stripe cache to look for stripe footers and index streams")
    public OrcCacheConfig setDwrfStripeCacheEnabled(boolean dwrfStripeCacheEnabled) {
        this.dwrfStripeCacheEnabled = dwrfStripeCacheEnabled;
        return this;
    }

    @MinDataSize(value="256B")
    public DataSize getExpectedFileTailSize() {
        return this.expectedFileTailSize;
    }

    @Config(value="orc.expected-file-tail-size")
    @ConfigDescription(value="Expected size of the file tail. This value should be increased to read StripeCache and footer in one IO")
    public OrcCacheConfig setExpectedFileTailSize(DataSize expectedFileTailSize) {
        this.expectedFileTailSize = expectedFileTailSize;
        return this;
    }
}

