/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.BooleanStatistics;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.HiveBloomFilter;
import com.facebook.presto.orc.metadata.statistics.StatisticsHasher;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class BooleanColumnStatistics
extends ColumnStatistics {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BooleanColumnStatistics.class).instanceSize();
    private final BooleanStatistics booleanStatistics;

    public BooleanColumnStatistics(Long numberOfValues, HiveBloomFilter bloomFilter, BooleanStatistics booleanStatistics) {
        super(numberOfValues, bloomFilter);
        Objects.requireNonNull(booleanStatistics, "booleanStatistics is null");
        this.booleanStatistics = booleanStatistics;
    }

    @Override
    public BooleanStatistics getBooleanStatistics() {
        return this.booleanStatistics;
    }

    @Override
    public long getTotalValueSizeInBytes() {
        return this.getNumberOfValues() * 2L;
    }

    @Override
    public ColumnStatistics withBloomFilter(HiveBloomFilter bloomFilter) {
        return new BooleanColumnStatistics(this.getNumberOfValues(), bloomFilter, this.booleanStatistics);
    }

    @Override
    public long getRetainedSizeInBytes() {
        long sizeInBytes = (long)INSTANCE_SIZE + super.getMembersSizeInBytes();
        return sizeInBytes + this.booleanStatistics.getRetainedSizeInBytes();
    }

    @Override
    public void addHash(StatisticsHasher hasher) {
        super.addHash(hasher);
        hasher.putOptionalHashable(this.booleanStatistics);
    }

    @Override
    protected MoreObjects.ToStringHelper getToStringHelper() {
        return super.getToStringHelper().add("booleanStatistics", (Object)this.booleanStatistics);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooleanColumnStatistics that = (BooleanColumnStatistics)o;
        return this.equalsInternal(that) && Objects.equals(this.booleanStatistics, that.booleanStatistics);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.booleanStatistics);
    }
}

