/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.HiveBloomFilter;
import com.facebook.presto.orc.metadata.statistics.MapStatistics;
import com.facebook.presto.orc.metadata.statistics.MapStatisticsEntry;
import com.facebook.presto.orc.metadata.statistics.StatisticsHasher;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class MapColumnStatistics
extends ColumnStatistics {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapColumnStatistics.class).instanceSize();
    private final MapStatistics mapStatistics;

    public MapColumnStatistics(Long numberOfValues, HiveBloomFilter bloomFilter, MapStatistics mapStatistics) {
        super(numberOfValues, bloomFilter);
        this.mapStatistics = Objects.requireNonNull(mapStatistics, "mapStatistics is null");
    }

    @Override
    public MapStatistics getMapStatistics() {
        return this.mapStatistics;
    }

    @Override
    public long getTotalValueSizeInBytes() {
        long size = 0L;
        for (MapStatisticsEntry entry : this.mapStatistics.getEntries()) {
            size += entry.getColumnStatistics().getTotalValueSizeInBytes();
        }
        return size;
    }

    @Override
    public ColumnStatistics withBloomFilter(HiveBloomFilter bloomFilter) {
        return new MapColumnStatistics(this.getNumberOfValues(), bloomFilter, this.mapStatistics);
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.getMembersSizeInBytes() + this.mapStatistics.getRetainedSizeInBytes();
    }

    @Override
    public void addHash(StatisticsHasher hasher) {
        super.addHash(hasher);
        hasher.putOptionalHashable(this.mapStatistics);
    }

    @Override
    protected MoreObjects.ToStringHelper getToStringHelper() {
        return super.getToStringHelper().add("mapStatistics", (Object)this.mapStatistics);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapColumnStatistics that = (MapColumnStatistics)o;
        return this.equalsInternal(that) && Objects.equals(this.mapStatistics, that.mapStatistics);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mapStatistics);
    }
}

