/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.DecodeTimestampOptions;
import com.facebook.presto.orc.reader.TimestampOutOfBoundsException;

final class ApacheHiveTimestampDecoder {
    private ApacheHiveTimestampDecoder() {
    }

    public static long decodeTimestamp(long seconds, long serializedNanos, DecodeTimestampOptions options) {
        boolean enableMicroPrecision = options.enableMicroPrecision();
        long secondsWithBase = seconds + options.getBaseSeconds();
        long value = ApacheHiveTimestampDecoder.getSecondsInRequiredUnits(enableMicroPrecision, secondsWithBase, options.getUnitsPerSecond());
        long nanos = ApacheHiveTimestampDecoder.parseNanos(serializedNanos);
        if (nanos > 999999999L || nanos < 0L) {
            throw new IllegalArgumentException("nanos field of an encoded timestamp in ORC must be between 0 and 999999999 inclusive, got " + nanos);
        }
        if (value < 0L && nanos != 0L) {
            value -= options.getUnitsPerSecond();
        }
        long truncatedNanos = nanos / options.getNanosPerUnit();
        return ApacheHiveTimestampDecoder.getValueWithNanos(enableMicroPrecision, value, truncatedNanos);
    }

    private static long getSecondsInRequiredUnits(boolean enableMicroPrecision, long secondsWithBase, long unitsPerSecond) {
        if (!enableMicroPrecision) {
            return secondsWithBase * unitsPerSecond;
        }
        try {
            return Math.multiplyExact(secondsWithBase, unitsPerSecond);
        }
        catch (ArithmeticException e) {
            String errorMessage = String.format("seconds field of timestamp exceeds maximum supported value, secondsWithBase: %s unitsPerSecond: %s.", secondsWithBase, unitsPerSecond);
            throw new TimestampOutOfBoundsException(errorMessage, e);
        }
    }

    private static long getValueWithNanos(boolean enableMicroPrecision, long value, long truncatedNanos) {
        if (!enableMicroPrecision) {
            return value + truncatedNanos;
        }
        try {
            return Math.addExact(value, truncatedNanos);
        }
        catch (ArithmeticException e) {
            String errorMessage = String.format("Timestamp exceeds maximum supported value, value: %s truncatedNanos: %s.", value, truncatedNanos);
            throw new TimestampOutOfBoundsException(errorMessage, e);
        }
    }

    private static int parseNanos(long serialized) {
        int zeros = (int)serialized & 7;
        int result = (int)(serialized >>> 3);
        if (zeros != 0) {
            for (int i = 0; i <= zeros; ++i) {
                result *= 10;
            }
        }
        return result;
    }
}

