/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.LongArrayBlock;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.DecodeTimestampOptions;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.Stripe;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.ApacheHiveTimestampDecoder;
import com.facebook.presto.orc.reader.BatchStreamReader;
import com.facebook.presto.orc.reader.ReaderUtils;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class TimestampBatchStreamReader
implements BatchStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(TimestampBatchStreamReader.class).instanceSize();
    private final StreamDescriptor streamDescriptor;
    private int readOffset;
    private int nextBatchSize;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.getBooleanMissingStreamSource();
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<LongInputStream> secondsStreamSource = MissingInputStreamSource.getLongMissingStreamSource();
    @Nullable
    private LongInputStream secondsStream;
    private InputStreamSource<LongInputStream> nanosStreamSource = MissingInputStreamSource.getLongMissingStreamSource();
    @Nullable
    private LongInputStream nanosStream;
    private boolean rowGroupOpen;
    private final DecodeTimestampOptions decodeTimestampOptions;

    public TimestampBatchStreamReader(Type type, StreamDescriptor streamDescriptor, DateTimeZone hiveStorageTimeZone, boolean enableMicroPrecision) throws OrcCorruptionException {
        this.decodeTimestampOptions = new DecodeTimestampOptions(hiveStorageTimeZone, enableMicroPrecision);
        Objects.requireNonNull(type, "type is null");
        ReaderUtils.verifyStreamType(streamDescriptor, type, TimestampType.class::isInstance);
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock() throws IOException {
        Block block;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.secondsStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but seconds stream is missing");
                }
                if (this.nanosStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but nanos stream is missing");
                }
                this.secondsStream.skip(this.readOffset);
                this.nanosStream.skip(this.readOffset);
            }
        }
        if (this.secondsStream == null && this.nanosStream == null) {
            if (this.presentStream == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is null but present stream is missing");
            }
            this.presentStream.skip(this.nextBatchSize);
            block = RunLengthEncodedBlock.create((Type)TimestampType.TIMESTAMP, null, (int)this.nextBatchSize);
        } else {
            boolean[] isNull;
            int nullCount;
            block = this.presentStream == null ? this.readNonNullBlock() : ((nullCount = this.presentStream.getUnsetBits(this.nextBatchSize, isNull = new boolean[this.nextBatchSize])) == 0 ? this.readNonNullBlock() : (nullCount != this.nextBatchSize ? this.readNullBlock(isNull) : RunLengthEncodedBlock.create((Type)TimestampType.TIMESTAMP, null, (int)this.nextBatchSize)));
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return block;
    }

    private Block readNonNullBlock() throws IOException {
        if (this.secondsStream == null) {
            throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but seconds stream is missing");
        }
        if (this.nanosStream == null) {
            throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but nanos stream is missing");
        }
        long[] values = new long[this.nextBatchSize];
        for (int i = 0; i < this.nextBatchSize; ++i) {
            values[i] = ApacheHiveTimestampDecoder.decodeTimestamp(this.secondsStream.next(), this.nanosStream.next(), this.decodeTimestampOptions);
        }
        return new LongArrayBlock(this.nextBatchSize, Optional.empty(), values);
    }

    private Block readNullBlock(boolean[] isNull) throws IOException {
        if (this.secondsStream == null) {
            throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but seconds stream is missing");
        }
        if (this.nanosStream == null) {
            throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but nanos stream is missing");
        }
        long[] values = new long[isNull.length];
        for (int i = 0; i < isNull.length; ++i) {
            if (isNull[i]) continue;
            values[i] = ApacheHiveTimestampDecoder.decodeTimestamp(this.secondsStream.next(), this.nanosStream.next(), this.decodeTimestampOptions);
        }
        return new LongArrayBlock(isNull.length, Optional.of(isNull), values);
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.secondsStream = this.secondsStreamSource.openStream();
        this.nanosStream = this.nanosStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(Stripe stripe) {
        this.presentStreamSource = MissingInputStreamSource.getBooleanMissingStreamSource();
        this.secondsStreamSource = MissingInputStreamSource.getLongMissingStreamSource();
        this.nanosStreamSource = MissingInputStreamSource.getLongMissingStreamSource();
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.secondsStream = null;
        this.nanosStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.secondsStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongInputStream.class);
        this.nanosStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.SECONDARY, LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.secondsStream = null;
        this.nanosStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public void close() {
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }
}

