/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.checkpoint.StreamCheckpoint;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressedMetadataWriter;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.stream.LongOutputStream;
import com.facebook.presto.orc.stream.LongOutputStreamV1;
import com.facebook.presto.orc.stream.LongOutputStreamV2;
import com.facebook.presto.orc.stream.PresentOutputStream;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.facebook.presto.orc.writer.ColumnWriterUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class TimestampColumnWriter
implements ColumnWriter {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(TimestampColumnWriter.class).instanceSize();
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int MICROS_PER_SECOND = 1000000;
    private static final int MILLIS_TO_NANOS_TRAILING_ZEROS = 5;
    private static final int MICROS_TO_NANOS_TRAILING_ZEROS = 2;
    private static final long TIMESTAMP_RAW_SIZE = 12L;
    private final int column;
    private final int sequence;
    private final Type type;
    private final boolean compressed;
    private final ColumnEncoding columnEncoding;
    private final LongOutputStream secondsStream;
    private final LongOutputStream nanosStream;
    private final PresentOutputStream presentStream;
    private final CompressedMetadataWriter metadataWriter;
    private final List<ColumnStatistics> rowGroupColumnStatistics = new ArrayList<ColumnStatistics>();
    private long columnStatisticsRetainedSizeInBytes;
    private final long baseTimestampInSeconds;
    private final long unitsPerSecond;
    private final int trailingZeros;
    private int nonNullValueCount;
    private boolean closed;

    public TimestampColumnWriter(int column, int sequence, Type type, ColumnWriterOptions columnWriterOptions, Optional<DwrfDataEncryptor> dwrfEncryptor, OrcEncoding orcEncoding, DateTimeZone hiveStorageTimeZone, MetadataWriter metadataWriter) {
        Preconditions.checkArgument((column >= 0 ? 1 : 0) != 0, (Object)"column is negative");
        Preconditions.checkArgument((sequence >= 0 ? 1 : 0) != 0, (Object)"sequence is negative");
        Objects.requireNonNull(columnWriterOptions, "compression is null");
        Objects.requireNonNull(dwrfEncryptor, "dwrfEncryptor is null");
        Objects.requireNonNull(metadataWriter, "metadataWriter is null");
        this.column = column;
        this.sequence = sequence;
        this.type = Objects.requireNonNull(type, "type is null");
        boolean bl = this.compressed = columnWriterOptions.getCompressionKind() != CompressionKind.NONE;
        if (type == TimestampType.TIMESTAMP) {
            this.unitsPerSecond = 1000L;
            this.trailingZeros = 5;
        } else if (type == TimestampType.TIMESTAMP_MICROSECONDS) {
            this.unitsPerSecond = 1000000L;
            this.trailingZeros = 2;
        } else {
            throw new UnsupportedOperationException("Unsupported Type: " + type);
        }
        if (orcEncoding == OrcEncoding.DWRF) {
            this.columnEncoding = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0);
            this.secondsStream = new LongOutputStreamV1(columnWriterOptions, dwrfEncryptor, true, Stream.StreamKind.DATA);
            this.nanosStream = new LongOutputStreamV1(columnWriterOptions, dwrfEncryptor, false, Stream.StreamKind.SECONDARY);
        } else {
            this.columnEncoding = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT_V2, 0);
            this.secondsStream = new LongOutputStreamV2(columnWriterOptions, true, Stream.StreamKind.DATA);
            this.nanosStream = new LongOutputStreamV2(columnWriterOptions, false, Stream.StreamKind.SECONDARY);
        }
        this.presentStream = new PresentOutputStream(columnWriterOptions, dwrfEncryptor);
        this.metadataWriter = new CompressedMetadataWriter(metadataWriter, columnWriterOptions, dwrfEncryptor);
        this.baseTimestampInSeconds = new DateTime(2015, 1, 1, 0, 0, Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null")).getMillis() / 1000L;
    }

    @Override
    public Map<Integer, ColumnEncoding> getColumnEncodings() {
        return ImmutableMap.of((Object)this.column, (Object)this.columnEncoding);
    }

    @Override
    public void beginRowGroup() {
        this.presentStream.recordCheckpoint();
        this.secondsStream.recordCheckpoint();
        this.nanosStream.recordCheckpoint();
    }

    @Override
    public long writeBlock(Block block) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((block.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"Block is empty");
        for (int position = 0; position < block.getPositionCount(); ++position) {
            this.presentStream.writeBoolean(!block.isNull(position));
        }
        int blockNonNullValueCount = 0;
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) continue;
            long value = this.type.getLong(block, position);
            long seconds = value / this.unitsPerSecond - this.baseTimestampInSeconds;
            long subSecondValue = Math.floorMod(value, this.unitsPerSecond);
            long encodedNanos = subSecondValue == 0L ? 0L : subSecondValue << 3 | (long)this.trailingZeros;
            this.secondsStream.writeLong(seconds);
            this.nanosStream.writeLong(encodedNanos);
            ++blockNonNullValueCount;
        }
        this.nonNullValueCount += blockNonNullValueCount;
        return (long)(block.getPositionCount() - blockNonNullValueCount) * 1L + (long)blockNonNullValueCount * 12L;
    }

    @Override
    public Map<Integer, ColumnStatistics> finishRowGroup() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ColumnStatistics statistics = new ColumnStatistics(Long.valueOf(this.nonNullValueCount), null);
        this.rowGroupColumnStatistics.add(statistics);
        this.columnStatisticsRetainedSizeInBytes += statistics.getRetainedSizeInBytes();
        this.nonNullValueCount = 0;
        return ImmutableMap.of((Object)this.column, (Object)statistics);
    }

    @Override
    public void close() {
        this.closed = true;
        this.secondsStream.close();
        this.nanosStream.close();
        this.presentStream.close();
    }

    @Override
    public Map<Integer, ColumnStatistics> getColumnStripeStatistics() {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableMap.of((Object)this.column, (Object)ColumnStatistics.mergeColumnStatistics(this.rowGroupColumnStatistics));
    }

    @Override
    public List<StreamDataOutput> getIndexStreams(Optional<List<? extends StreamCheckpoint>> prependCheckpoints) throws IOException {
        Preconditions.checkState((boolean)this.closed);
        List<RowGroupIndex> rowGroupIndexes = ColumnWriterUtils.buildRowGroupIndexes(this.compressed, this.rowGroupColumnStatistics, prependCheckpoints, this.presentStream, this.secondsStream, this.nanosStream);
        Slice slice = this.metadataWriter.writeRowIndexes(rowGroupIndexes);
        Stream stream = new Stream(this.column, this.sequence, Stream.StreamKind.ROW_INDEX, slice.length(), false);
        return ImmutableList.of((Object)new StreamDataOutput(slice, stream));
    }

    @Override
    public List<StreamDataOutput> getDataStreams() {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder outputDataStreams = ImmutableList.builder();
        this.presentStream.getStreamDataOutput(this.column, this.sequence).ifPresent(arg_0 -> ((ImmutableList.Builder)outputDataStreams).add(arg_0));
        outputDataStreams.add((Object)this.secondsStream.getStreamDataOutput(this.column, this.sequence));
        outputDataStreams.add((Object)this.nanosStream.getStreamDataOutput(this.column, this.sequence));
        return outputDataStreams.build();
    }

    @Override
    public long getBufferedBytes() {
        return this.secondsStream.getBufferedBytes() + this.nanosStream.getBufferedBytes() + this.presentStream.getBufferedBytes();
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.secondsStream.getRetainedBytes() + this.nanosStream.getRetainedBytes() + this.presentStream.getRetainedBytes() + this.columnStatisticsRetainedSizeInBytes;
    }

    @Override
    public void reset() {
        this.closed = false;
        this.secondsStream.reset();
        this.nanosStream.reset();
        this.presentStream.reset();
        this.rowGroupColumnStatistics.clear();
        this.columnStatisticsRetainedSizeInBytes = 0L;
        this.nonNullValueCount = 0;
    }
}

