/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.AbstractOrcRecordReader;
import com.facebook.presto.orc.EncryptionLibrary;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDecompressor;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcRecordReaderOptions;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.StreamDescriptorFactory;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.StripeStatistics;
import com.facebook.presto.orc.reader.BatchStreamReader;
import com.facebook.presto.orc.reader.BatchStreamReaders;
import com.facebook.presto.orc.reader.StreamReader;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class OrcBatchRecordReader
extends AbstractOrcRecordReader<BatchStreamReader> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(OrcBatchRecordReader.class).instanceSize();

    public OrcBatchRecordReader(Map<Integer, Type> includedColumns, OrcPredicate predicate, long numberOfRows, List<StripeInformation> fileStripes, List<ColumnStatistics> fileStats, List<StripeStatistics> stripeStats, OrcDataSource orcDataSource, long splitOffset, long splitLength, List<OrcType> types, Optional<OrcDecompressor> decompressor, Optional<EncryptionLibrary> encryptionLibrary, Map<Integer, Integer> dwrfEncryptionGroupMap, Map<Integer, Slice> intermediateKeyMetadata, int rowsInRowGroup, DateTimeZone hiveStorageTimeZone, OrcRecordReaderOptions options, PostScript.HiveWriterVersion hiveWriterVersion, MetadataReader metadataReader, Map<String, Slice> userMetadata, OrcAggregatedMemoryContext systemMemoryUsage, Optional<OrcWriteValidation> writeValidation, int initialBatchSize, StripeMetadataSource stripeMetadataSource, boolean cacheable, RuntimeStats runtimeStats) throws OrcCorruptionException {
        super(includedColumns, (Map)ImmutableMap.of(), (StreamReader[])OrcBatchRecordReader.createStreamReaders(orcDataSource, types, hiveStorageTimeZone, options, includedColumns, systemMemoryUsage.newOrcAggregatedMemoryContext()), predicate, numberOfRows, fileStripes, fileStats, stripeStats, orcDataSource, splitOffset, splitLength, types, decompressor, encryptionLibrary, dwrfEncryptionGroupMap, intermediateKeyMetadata, rowsInRowGroup, hiveStorageTimeZone, hiveWriterVersion, metadataReader, options.getMaxMergeDistance(), options.getTinyStripeThreshold(), options.getMaxBlockSize(), userMetadata, systemMemoryUsage, writeValidation, initialBatchSize, stripeMetadataSource, cacheable, runtimeStats, Optional.empty());
    }

    public int nextBatch() throws IOException {
        int batchSize = this.prepareNextBatch();
        if (batchSize < 0) {
            return batchSize;
        }
        for (BatchStreamReader column : (BatchStreamReader[])this.getStreamReaders()) {
            if (column == null) continue;
            column.prepareNextRead(batchSize);
        }
        this.batchRead(batchSize);
        this.validateWritePageChecksum(batchSize);
        return batchSize;
    }

    public Block readBlock(int columnIndex) throws IOException {
        Block block = ((BatchStreamReader[])this.getStreamReaders())[columnIndex].readBlock();
        this.updateMaxCombinedBytesPerRow(columnIndex, block);
        return block;
    }

    private void validateWritePageChecksum(int batchSize) throws IOException {
        if (this.shouldValidateWritePageChecksum()) {
            Block[] blocks = new Block[((BatchStreamReader[])this.getStreamReaders()).length];
            for (int columnIndex = 0; columnIndex < ((BatchStreamReader[])this.getStreamReaders()).length; ++columnIndex) {
                blocks[columnIndex] = this.readBlock(columnIndex);
            }
            Page page = new Page(batchSize, blocks);
            this.validateWritePageChecksum(page);
        }
    }

    private static BatchStreamReader[] createStreamReaders(OrcDataSource orcDataSource, List<OrcType> types, DateTimeZone hiveStorageTimeZone, OrcRecordReaderOptions options, Map<Integer, Type> includedColumns, OrcAggregatedMemoryContext systemMemoryContext) throws OrcCorruptionException {
        List<StreamDescriptor> streamDescriptors = StreamDescriptorFactory.createStreamDescriptor(types, orcDataSource).getNestedStreams();
        OrcType rowType = types.get(0);
        BatchStreamReader[] streamReaders = new BatchStreamReader[rowType.getFieldCount()];
        for (int columnId = 0; columnId < rowType.getFieldCount(); ++columnId) {
            Type type;
            if (!includedColumns.containsKey(columnId) || (type = includedColumns.get(columnId)) == null) continue;
            StreamDescriptor streamDescriptor = streamDescriptors.get(columnId);
            streamReaders[columnId] = BatchStreamReaders.createStreamReader(type, streamDescriptor, hiveStorageTimeZone, options, systemMemoryContext);
        }
        return streamReaders;
    }
}

