/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.IntegerColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.IntegerStatistics;
import com.facebook.presto.orc.metadata.statistics.LongValueStatisticsBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class IntegerStatisticsBuilder
implements LongValueStatisticsBuilder {
    private long nonNullValueCount;
    private long storageSize;
    private long rawSize;
    private long minimum = Long.MAX_VALUE;
    private long maximum = Long.MIN_VALUE;
    private long sum;
    private boolean overflow;

    @Override
    public void addValue(long value) {
        ++this.nonNullValueCount;
        this.minimum = Math.min(value, this.minimum);
        this.maximum = Math.max(value, this.maximum);
        if (!this.overflow) {
            try {
                this.sum = Math.addExact(this.sum, value);
            }
            catch (ArithmeticException e) {
                this.overflow = true;
            }
        }
    }

    public long getMaximum() {
        return this.maximum;
    }

    private void addIntegerStatistics(long valueCount, IntegerStatistics value) {
        Objects.requireNonNull(value, "value is null");
        this.nonNullValueCount += valueCount;
        this.minimum = Math.min(value.getMinPrimitive(), this.minimum);
        this.maximum = Math.max(value.getMaxPrimitive(), this.maximum);
        if (!value.hasSum()) {
            this.overflow = true;
        } else if (!this.overflow) {
            try {
                this.sum = Math.addExact(this.sum, value.getSumPrimitive());
            }
            catch (ArithmeticException e) {
                this.overflow = true;
            }
        }
    }

    private Optional<IntegerStatistics> buildIntegerStatistics() {
        if (this.nonNullValueCount == 0L) {
            return Optional.empty();
        }
        return Optional.of(new IntegerStatistics(this.minimum, this.maximum, this.overflow ? null : Long.valueOf(this.sum)));
    }

    @Override
    public ColumnStatistics buildColumnStatistics() {
        Optional<IntegerStatistics> integerStatistics = this.buildIntegerStatistics();
        if (integerStatistics.isPresent()) {
            return new IntegerColumnStatistics(this.nonNullValueCount, null, this.rawSize, this.storageSize, integerStatistics.get());
        }
        return new ColumnStatistics(this.nonNullValueCount, null, this.rawSize, this.storageSize);
    }

    @Override
    public void incrementRawSize(long rawSize) {
        this.rawSize += rawSize;
    }

    @Override
    public void incrementSize(long storageSize) {
        this.storageSize += storageSize;
    }

    public static Optional<IntegerStatistics> mergeIntegerStatistics(List<ColumnStatistics> stats) {
        IntegerStatisticsBuilder integerStatisticsBuilder = new IntegerStatisticsBuilder();
        for (ColumnStatistics columnStatistics : stats) {
            IntegerStatistics partialStatistics = columnStatistics.getIntegerStatistics();
            if (columnStatistics.getNumberOfValues() <= 0L) continue;
            if (partialStatistics == null) {
                return Optional.empty();
            }
            integerStatisticsBuilder.addIntegerStatistics(columnStatistics.getNumberOfValues(), partialStatistics);
        }
        return integerStatisticsBuilder.buildIntegerStatistics();
    }
}

