/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcRecordReaderOptions;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.reader.BatchStreamReader;
import com.facebook.presto.orc.reader.BooleanBatchStreamReader;
import com.facebook.presto.orc.reader.ByteBatchStreamReader;
import com.facebook.presto.orc.reader.DecimalBatchStreamReader;
import com.facebook.presto.orc.reader.DoubleBatchStreamReader;
import com.facebook.presto.orc.reader.FloatBatchStreamReader;
import com.facebook.presto.orc.reader.ListBatchStreamReader;
import com.facebook.presto.orc.reader.LongBatchStreamReader;
import com.facebook.presto.orc.reader.MapBatchStreamReader;
import com.facebook.presto.orc.reader.SliceBatchStreamReader;
import com.facebook.presto.orc.reader.StructBatchStreamReader;
import com.facebook.presto.orc.reader.TimestampBatchStreamReader;
import org.joda.time.DateTimeZone;

public final class BatchStreamReaders {
    private BatchStreamReaders() {
    }

    public static BatchStreamReader createStreamReader(Type type, StreamDescriptor streamDescriptor, DateTimeZone hiveStorageTimeZone, OrcRecordReaderOptions options, OrcAggregatedMemoryContext systemMemoryContext) throws OrcCorruptionException {
        switch (streamDescriptor.getOrcTypeKind()) {
            case BOOLEAN: {
                return new BooleanBatchStreamReader(type, streamDescriptor, systemMemoryContext.newOrcLocalMemoryContext(BatchStreamReaders.class.getSimpleName()));
            }
            case BYTE: {
                return new ByteBatchStreamReader(type, streamDescriptor, systemMemoryContext.newOrcLocalMemoryContext(BatchStreamReaders.class.getSimpleName()));
            }
            case SHORT: 
            case INT: 
            case LONG: 
            case DATE: {
                return new LongBatchStreamReader(type, streamDescriptor, systemMemoryContext);
            }
            case FLOAT: {
                return new FloatBatchStreamReader(type, streamDescriptor);
            }
            case DOUBLE: {
                return new DoubleBatchStreamReader(type, streamDescriptor);
            }
            case BINARY: 
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return new SliceBatchStreamReader(type, streamDescriptor, systemMemoryContext);
            }
            case TIMESTAMP: 
            case TIMESTAMP_MICROSECONDS: {
                boolean enableMicroPrecision = type == TimestampType.TIMESTAMP_MICROSECONDS;
                return new TimestampBatchStreamReader(type, streamDescriptor, hiveStorageTimeZone, enableMicroPrecision);
            }
            case LIST: {
                return new ListBatchStreamReader(type, streamDescriptor, hiveStorageTimeZone, options, systemMemoryContext);
            }
            case STRUCT: {
                return new StructBatchStreamReader(type, streamDescriptor, hiveStorageTimeZone, options, systemMemoryContext);
            }
            case MAP: {
                return new MapBatchStreamReader(type, streamDescriptor, hiveStorageTimeZone, options, systemMemoryContext);
            }
            case DECIMAL: {
                return new DecimalBatchStreamReader(type, streamDescriptor);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)streamDescriptor.getOrcTypeKind()));
    }
}

