/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.checkpoint.StreamCheckpoint;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressedMetadataWriter;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.DoubleStatisticsBuilder;
import com.facebook.presto.orc.stream.DoubleOutputStream;
import com.facebook.presto.orc.stream.PresentOutputStream;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.facebook.presto.orc.writer.ColumnWriterUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class DoubleColumnWriter
implements ColumnWriter {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DoubleColumnWriter.class).instanceSize();
    private static final ColumnEncoding COLUMN_ENCODING = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0);
    private static final long TYPE_SIZE = 8L;
    private final int column;
    private final int sequence;
    private final Type type;
    private final boolean compressed;
    private final DoubleOutputStream dataStream;
    private final PresentOutputStream presentStream;
    private final CompressedMetadataWriter metadataWriter;
    private final List<ColumnStatistics> rowGroupColumnStatistics = new ArrayList<ColumnStatistics>();
    private long columnStatisticsRetainedSizeInBytes;
    private DoubleStatisticsBuilder statisticsBuilder = new DoubleStatisticsBuilder();
    private boolean closed;

    public DoubleColumnWriter(int column, int sequence, Type type, ColumnWriterOptions columnWriterOptions, Optional<DwrfDataEncryptor> dwrfEncryptor, MetadataWriter metadataWriter) {
        Preconditions.checkArgument((column >= 0 ? 1 : 0) != 0, (Object)"column is negative");
        Preconditions.checkArgument((sequence >= 0 ? 1 : 0) != 0, (Object)"sequence is negative");
        Objects.requireNonNull(columnWriterOptions, "columnWriterOptions is null");
        Objects.requireNonNull(dwrfEncryptor, "dwrfEncryptor is null");
        Objects.requireNonNull(metadataWriter, "metadataWriter is null");
        this.column = column;
        this.sequence = sequence;
        this.type = Objects.requireNonNull(type, "type is null");
        this.compressed = columnWriterOptions.getCompressionKind() != CompressionKind.NONE;
        this.dataStream = new DoubleOutputStream(columnWriterOptions, dwrfEncryptor);
        this.presentStream = new PresentOutputStream(columnWriterOptions, dwrfEncryptor);
        this.metadataWriter = new CompressedMetadataWriter(metadataWriter, columnWriterOptions, dwrfEncryptor);
    }

    @Override
    public Map<Integer, ColumnEncoding> getColumnEncodings() {
        return ImmutableMap.of((Object)this.column, (Object)COLUMN_ENCODING);
    }

    @Override
    public void beginRowGroup() {
        this.presentStream.recordCheckpoint();
        this.dataStream.recordCheckpoint();
    }

    @Override
    public long writeBlock(Block block) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((block.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"Block is empty");
        for (int position = 0; position < block.getPositionCount(); ++position) {
            this.presentStream.writeBoolean(!block.isNull(position));
        }
        int nonNullValueCount = 0;
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) continue;
            double value = this.type.getDouble(block, position);
            this.statisticsBuilder.addValue(value);
            this.dataStream.writeDouble(value);
            ++nonNullValueCount;
        }
        long rawSize = (long)nonNullValueCount * 8L + (long)(block.getPositionCount() - nonNullValueCount) * 1L;
        this.statisticsBuilder.incrementRawSize(rawSize);
        return rawSize;
    }

    @Override
    public Map<Integer, ColumnStatistics> finishRowGroup() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ColumnStatistics statistics = this.statisticsBuilder.buildColumnStatistics();
        this.rowGroupColumnStatistics.add(statistics);
        this.columnStatisticsRetainedSizeInBytes += statistics.getRetainedSizeInBytes();
        this.statisticsBuilder = new DoubleStatisticsBuilder();
        return ImmutableMap.of((Object)this.column, (Object)statistics);
    }

    @Override
    public void close() {
        this.closed = true;
        this.dataStream.close();
        this.presentStream.close();
    }

    @Override
    public Map<Integer, ColumnStatistics> getColumnStripeStatistics() {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableMap.of((Object)this.column, (Object)ColumnStatistics.mergeColumnStatistics(this.rowGroupColumnStatistics));
    }

    @Override
    public List<StreamDataOutput> getIndexStreams(Optional<List<? extends StreamCheckpoint>> prependCheckpoints) throws IOException {
        Preconditions.checkState((boolean)this.closed);
        List<RowGroupIndex> rowGroupIndexes = ColumnWriterUtils.buildRowGroupIndexes(this.compressed, this.rowGroupColumnStatistics, prependCheckpoints, this.presentStream, this.dataStream);
        Slice slice = this.metadataWriter.writeRowIndexes(rowGroupIndexes);
        Stream stream = new Stream(this.column, this.sequence, Stream.StreamKind.ROW_INDEX, slice.length(), false);
        return ImmutableList.of((Object)new StreamDataOutput(slice, stream));
    }

    @Override
    public List<StreamDataOutput> getDataStreams() {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder outputDataStreams = ImmutableList.builder();
        this.presentStream.getStreamDataOutput(this.column, this.sequence).ifPresent(arg_0 -> ((ImmutableList.Builder)outputDataStreams).add(arg_0));
        outputDataStreams.add((Object)this.dataStream.getStreamDataOutput(this.column, this.sequence));
        return outputDataStreams.build();
    }

    @Override
    public long getBufferedBytes() {
        return this.dataStream.getBufferedBytes() + this.presentStream.getBufferedBytes();
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.dataStream.getRetainedBytes() + this.presentStream.getRetainedBytes() + this.columnStatisticsRetainedSizeInBytes;
    }

    @Override
    public void reset() {
        this.closed = false;
        this.dataStream.reset();
        this.presentStream.reset();
        this.rowGroupColumnStatistics.clear();
        this.columnStatisticsRetainedSizeInBytes = 0L;
        this.statisticsBuilder = new DoubleStatisticsBuilder();
    }
}

