/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.zstd;

import com.github.luben.zstd.Zstd;
import io.airlift.compress.Decompressor;
import io.airlift.compress.MalformedInputException;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class ZstdJniDecompressor
implements Decompressor {
    public int decompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) throws MalformedInputException {
        long size = Zstd.decompressByteArray((byte[])output, (int)0, (int)maxOutputLength, (byte[])input, (int)inputOffset, (int)inputLength);
        if (Zstd.isError((long)size)) {
            String errorName = Zstd.getErrorName((long)size);
            throw new MalformedInputException((long)inputOffset, "Zstd JNI decompressor failed with " + errorName);
        }
        return StrictMath.toIntExact(size);
    }

    public void decompress(ByteBuffer input, ByteBuffer output) throws MalformedInputException {
        if (input.isDirect() || output.isDirect() || !input.hasArray() || !output.hasArray()) {
            throw new IllegalArgumentException("Non-direct byte buffer backed by byte array required");
        }
        int inputOffset = input.arrayOffset() + input.position();
        int outputOffset = output.arrayOffset() + output.position();
        int written = this.decompress(input.array(), inputOffset, input.remaining(), output.array(), outputOffset, output.remaining());
        ((Buffer)output).position(output.position() + written);
    }
}

