/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import java.util.Objects;

public final class OrcDataSourceId {
    private final String id;

    public OrcDataSourceId(String id) {
        this.id = Objects.requireNonNull(id, "id is null");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrcDataSourceId that = (OrcDataSourceId)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.id;
    }

    public void attachToException(Throwable throwable) {
        Objects.requireNonNull(throwable, "throwable is null");
        throwable.addSuppressed(new OrcDataSourceIdStackInfoException(this));
    }

    private static class OrcDataSourceIdStackInfoException
    extends RuntimeException {
        public OrcDataSourceIdStackInfoException(OrcDataSourceId orcDataSourceId) {
            super("Failed to read ORC file: " + orcDataSourceId);
            this.setStackTrace(new StackTraceElement[0]);
        }
    }
}

