/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.DefaultOrcWriterFlushPolicy;
import com.facebook.presto.orc.DwrfStripeCacheOptions;
import com.facebook.presto.orc.OrcWriterFlushPolicy;
import com.facebook.presto.orc.metadata.DwrfStripeCacheMode;
import com.facebook.presto.orc.writer.StreamLayoutFactory;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;

public class OrcWriterOptions {
    public static final int DEFAULT_ROW_GROUP_MAX_ROW_COUNT = 10000;
    public static final DataSize DEFAULT_DICTIONARY_MAX_MEMORY = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    public static final DataSize DEFAULT_DICTIONARY_MEMORY_ALMOST_FULL_RANGE = new DataSize(4.0, DataSize.Unit.MEGABYTE);
    public static final int DEFAULT_DICTIONARY_USEFUL_CHECK_PER_CHUNK_FREQUENCY = Integer.MAX_VALUE;
    public static final DataSize DEFAULT_DICTIONARY_USEFUL_CHECK_COLUMN_SIZE = new DataSize(6.0, DataSize.Unit.MEGABYTE);
    public static final DataSize DEFAULT_MAX_STRING_STATISTICS_LIMIT = new DataSize(64.0, DataSize.Unit.BYTE);
    public static final DataSize DEFAULT_MAX_COMPRESSION_BUFFER_SIZE = new DataSize(256.0, DataSize.Unit.KILOBYTE);
    public static final DataSize DEFAULT_DWRF_STRIPE_CACHE_MAX_SIZE = new DataSize(8.0, DataSize.Unit.MEGABYTE);
    public static final DwrfStripeCacheMode DEFAULT_DWRF_STRIPE_CACHE_MODE = DwrfStripeCacheMode.INDEX_AND_FOOTER;
    public static final int DEFAULT_PRESERVE_DIRECT_ENCODING_STRIPE_COUNT = 0;
    public static final int DEFAULT_MAX_FLATTENED_MAP_KEY_COUNT = 25000;
    public static final boolean DEFAULT_INTEGER_DICTIONARY_ENCODING_ENABLED = false;
    public static final boolean DEFAULT_STRING_DICTIONARY_ENCODING_ENABLED = true;
    public static final boolean DEFAULT_STRING_DICTIONARY_SORTING_ENABLED = true;
    private final OrcWriterFlushPolicy flushPolicy;
    private final int rowGroupMaxRowCount;
    private final DataSize dictionaryMaxMemory;
    private final DataSize dictionaryMemoryAlmostFullRange;
    private final int dictionaryUsefulCheckPerChunkFrequency;
    private final DataSize dictionaryUsefulCheckColumnSize;
    private final DataSize maxStringStatisticsLimit;
    private final DataSize maxCompressionBufferSize;
    private final OptionalInt compressionLevel;
    private final StreamLayoutFactory streamLayoutFactory;
    private final boolean integerDictionaryEncodingEnabled;
    private final boolean stringDictionarySortingEnabled;
    private final boolean stringDictionaryEncodingEnabled;
    private final boolean ignoreDictionaryRowGroupSizes;
    private final Optional<DwrfStripeCacheOptions> dwrfWriterOptions;
    private final int preserveDirectEncodingStripeCount;
    private final boolean mapStatisticsEnabled;
    private final int maxFlattenedMapKeyCount;
    private final Set<Integer> flattenedColumns;

    private OrcWriterOptions(OrcWriterFlushPolicy flushPolicy, int rowGroupMaxRowCount, DataSize dictionaryMaxMemory, DataSize dictionaryMemoryAlmostFullRange, int dictionaryUsefulCheckPerChunkFrequency, DataSize dictionaryUsefulCheckColumnSize, DataSize maxStringStatisticsLimit, DataSize maxCompressionBufferSize, OptionalInt compressionLevel, StreamLayoutFactory streamLayoutFactory, boolean integerDictionaryEncodingEnabled, boolean stringDictionarySortingEnabled, boolean stringDictionaryEncodingEnabled, Optional<DwrfStripeCacheOptions> dwrfWriterOptions, boolean ignoreDictionaryRowGroupSizes, int preserveDirectEncodingStripeCount, Set<Integer> flattenedColumns, boolean mapStatisticsEnabled, int maxFlattenedMapKeyCount) {
        Objects.requireNonNull(flushPolicy, "flushPolicy is null");
        Preconditions.checkArgument((rowGroupMaxRowCount >= 1 ? 1 : 0) != 0, (Object)"rowGroupMaxRowCount must be at least 1");
        Objects.requireNonNull(dictionaryMaxMemory, "dictionaryMaxMemory is null");
        Objects.requireNonNull(dictionaryMemoryAlmostFullRange, "dictionaryMemoryAlmostFullRange is null");
        Objects.requireNonNull(dictionaryUsefulCheckColumnSize, "dictionaryUsefulCheckColumnSize is null");
        Objects.requireNonNull(maxStringStatisticsLimit, "maxStringStatisticsLimit is null");
        Objects.requireNonNull(maxCompressionBufferSize, "maxCompressionBufferSize is null");
        Objects.requireNonNull(compressionLevel, "compressionLevel is null");
        Objects.requireNonNull(streamLayoutFactory, "streamLayoutFactory is null");
        Objects.requireNonNull(dwrfWriterOptions, "dwrfWriterOptions is null");
        Objects.requireNonNull(flattenedColumns, "flattenedColumns is null");
        Preconditions.checkArgument((maxFlattenedMapKeyCount > 0 ? 1 : 0) != 0, (String)"maxFlattenedMapKeyCount must be positive: %s", (int)maxFlattenedMapKeyCount);
        this.flushPolicy = flushPolicy;
        this.rowGroupMaxRowCount = rowGroupMaxRowCount;
        this.dictionaryMaxMemory = dictionaryMaxMemory;
        this.dictionaryMemoryAlmostFullRange = dictionaryMemoryAlmostFullRange;
        this.dictionaryUsefulCheckPerChunkFrequency = dictionaryUsefulCheckPerChunkFrequency;
        this.dictionaryUsefulCheckColumnSize = dictionaryUsefulCheckColumnSize;
        this.maxStringStatisticsLimit = maxStringStatisticsLimit;
        this.maxCompressionBufferSize = maxCompressionBufferSize;
        this.compressionLevel = compressionLevel;
        this.streamLayoutFactory = streamLayoutFactory;
        this.integerDictionaryEncodingEnabled = integerDictionaryEncodingEnabled;
        this.stringDictionarySortingEnabled = stringDictionarySortingEnabled;
        this.stringDictionaryEncodingEnabled = stringDictionaryEncodingEnabled;
        this.dwrfWriterOptions = dwrfWriterOptions;
        this.ignoreDictionaryRowGroupSizes = ignoreDictionaryRowGroupSizes;
        this.preserveDirectEncodingStripeCount = preserveDirectEncodingStripeCount;
        this.flattenedColumns = flattenedColumns;
        this.mapStatisticsEnabled = mapStatisticsEnabled;
        this.maxFlattenedMapKeyCount = maxFlattenedMapKeyCount;
    }

    public OrcWriterFlushPolicy getFlushPolicy() {
        return this.flushPolicy;
    }

    public int getRowGroupMaxRowCount() {
        return this.rowGroupMaxRowCount;
    }

    public DataSize getDictionaryMaxMemory() {
        return this.dictionaryMaxMemory;
    }

    public DataSize getDictionaryMemoryAlmostFullRange() {
        return this.dictionaryMemoryAlmostFullRange;
    }

    public int getDictionaryUsefulCheckPerChunkFrequency() {
        return this.dictionaryUsefulCheckPerChunkFrequency;
    }

    public DataSize getDictionaryUsefulCheckColumnSize() {
        return this.dictionaryUsefulCheckColumnSize;
    }

    public DataSize getMaxStringStatisticsLimit() {
        return this.maxStringStatisticsLimit;
    }

    public DataSize getMaxCompressionBufferSize() {
        return this.maxCompressionBufferSize;
    }

    public OptionalInt getCompressionLevel() {
        return this.compressionLevel;
    }

    public StreamLayoutFactory getStreamLayoutFactory() {
        return this.streamLayoutFactory;
    }

    public boolean isIntegerDictionaryEncodingEnabled() {
        return this.integerDictionaryEncodingEnabled;
    }

    public boolean isStringDictionarySortingEnabled() {
        return this.stringDictionarySortingEnabled;
    }

    public boolean isStringDictionaryEncodingEnabled() {
        return this.stringDictionaryEncodingEnabled;
    }

    public Optional<DwrfStripeCacheOptions> getDwrfStripeCacheOptions() {
        return this.dwrfWriterOptions;
    }

    public boolean isIgnoreDictionaryRowGroupSizes() {
        return this.ignoreDictionaryRowGroupSizes;
    }

    public int getPreserveDirectEncodingStripeCount() {
        return this.preserveDirectEncodingStripeCount;
    }

    public Set<Integer> getFlattenedColumns() {
        return this.flattenedColumns;
    }

    public boolean isMapStatisticsEnabled() {
        return this.mapStatisticsEnabled;
    }

    public int getMaxFlattenedMapKeyCount() {
        return this.maxFlattenedMapKeyCount;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("flushPolicy", (Object)this.flushPolicy).add("rowGroupMaxRowCount", this.rowGroupMaxRowCount).add("dictionaryMaxMemory", (Object)this.dictionaryMaxMemory).add("dictionaryMemoryAlmostFullRange", (Object)this.dictionaryMemoryAlmostFullRange).add("dictionaryUsefulCheckPerChunkFrequency", this.dictionaryUsefulCheckPerChunkFrequency).add("dictionaryUsefulCheckColumnSize", (Object)this.dictionaryUsefulCheckColumnSize).add("maxStringStatisticsLimit", (Object)this.maxStringStatisticsLimit).add("maxCompressionBufferSize", (Object)this.maxCompressionBufferSize).add("compressionLevel", (Object)this.compressionLevel).add("streamLayoutFactory", (Object)this.streamLayoutFactory).add("integerDictionaryEncodingEnabled", this.integerDictionaryEncodingEnabled).add("stringDictionarySortingEnabled", this.stringDictionarySortingEnabled).add("stringDictionaryEncodingEnabled", this.stringDictionaryEncodingEnabled).add("dwrfWriterOptions", this.dwrfWriterOptions).add("ignoreDictionaryRowGroupSizes", this.ignoreDictionaryRowGroupSizes).add("preserveDirectEncodingStripeCount", this.preserveDirectEncodingStripeCount).add("flattenedColumns", this.flattenedColumns).add("mapStatisticsEnabled", this.mapStatisticsEnabled).add("maxFlattenedMapKeyCount", this.maxFlattenedMapKeyCount).toString();
    }

    public static OrcWriterOptions getDefaultOrcWriterOptions() {
        return OrcWriterOptions.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private OrcWriterFlushPolicy flushPolicy = DefaultOrcWriterFlushPolicy.builder().build();
        private int rowGroupMaxRowCount = 10000;
        private DataSize dictionaryMaxMemory = DEFAULT_DICTIONARY_MAX_MEMORY;
        private DataSize dictionaryMemoryAlmostFullRange = DEFAULT_DICTIONARY_MEMORY_ALMOST_FULL_RANGE;
        private int dictionaryUsefulCheckPerChunkFrequency = Integer.MAX_VALUE;
        private DataSize dictionaryUsefulCheckColumnSize = DEFAULT_DICTIONARY_USEFUL_CHECK_COLUMN_SIZE;
        private DataSize maxStringStatisticsLimit = DEFAULT_MAX_STRING_STATISTICS_LIMIT;
        private DataSize maxCompressionBufferSize = DEFAULT_MAX_COMPRESSION_BUFFER_SIZE;
        private OptionalInt compressionLevel = OptionalInt.empty();
        private StreamLayoutFactory streamLayoutFactory = new StreamLayoutFactory.ColumnSizeLayoutFactory();
        private boolean integerDictionaryEncodingEnabled = false;
        private boolean stringDictionarySortingEnabled = true;
        private boolean stringDictionaryEncodingEnabled = true;
        private boolean dwrfStripeCacheEnabled;
        private DwrfStripeCacheMode dwrfStripeCacheMode = DEFAULT_DWRF_STRIPE_CACHE_MODE;
        private DataSize dwrfStripeCacheMaxSize = DEFAULT_DWRF_STRIPE_CACHE_MAX_SIZE;
        private boolean ignoreDictionaryRowGroupSizes;
        private int preserveDirectEncodingStripeCount = 0;
        private Set<Integer> flattenedColumns = ImmutableSet.of();
        private boolean mapStatisticsEnabled;
        private int maxFlattenedMapKeyCount = 25000;

        public Builder withFlushPolicy(OrcWriterFlushPolicy flushPolicy) {
            this.flushPolicy = Objects.requireNonNull(flushPolicy, "flushPolicy is null");
            return this;
        }

        public Builder withRowGroupMaxRowCount(int rowGroupMaxRowCount) {
            Preconditions.checkArgument((rowGroupMaxRowCount >= 1 ? 1 : 0) != 0, (Object)"rowGroupMaxRowCount must be at least 1");
            this.rowGroupMaxRowCount = rowGroupMaxRowCount;
            return this;
        }

        public Builder withDictionaryMaxMemory(DataSize dictionaryMaxMemory) {
            this.dictionaryMaxMemory = Objects.requireNonNull(dictionaryMaxMemory, "dictionaryMaxMemory is null");
            return this;
        }

        public Builder withDictionaryMemoryAlmostFullRange(DataSize dictionaryMemoryAlmostFullRange) {
            this.dictionaryMemoryAlmostFullRange = Objects.requireNonNull(dictionaryMemoryAlmostFullRange, "dictionaryMemoryAlmostFullRange is null");
            return this;
        }

        public Builder withDictionaryUsefulCheckPerChunkFrequency(int dictionaryUsefulCheckPerChunkFrequency) {
            Preconditions.checkArgument((dictionaryUsefulCheckPerChunkFrequency >= 0 ? 1 : 0) != 0, (Object)"dictionaryUsefulCheckPerChunkFrequency is negative");
            this.dictionaryUsefulCheckPerChunkFrequency = dictionaryUsefulCheckPerChunkFrequency;
            return this;
        }

        public Builder withDictionaryUsefulCheckColumnSize(DataSize dictionaryUsefulCheckColumnSize) {
            this.dictionaryUsefulCheckColumnSize = Objects.requireNonNull(dictionaryUsefulCheckColumnSize, "dictionaryUsefulCheckColumnSize is null");
            return this;
        }

        public Builder withMaxStringStatisticsLimit(DataSize maxStringStatisticsLimit) {
            this.maxStringStatisticsLimit = Objects.requireNonNull(maxStringStatisticsLimit, "maxStringStatisticsLimit is null");
            return this;
        }

        public Builder withMaxCompressionBufferSize(DataSize maxCompressionBufferSize) {
            this.maxCompressionBufferSize = Objects.requireNonNull(maxCompressionBufferSize, "maxCompressionBufferSize is null");
            return this;
        }

        public Builder withCompressionLevel(OptionalInt compressionLevel) {
            this.compressionLevel = Objects.requireNonNull(compressionLevel, "compressionLevel is null");
            return this;
        }

        public Builder withStreamLayoutFactory(StreamLayoutFactory streamLayoutFactory) {
            this.streamLayoutFactory = Objects.requireNonNull(streamLayoutFactory, "streamLayoutFactory is null");
            return this;
        }

        public Builder withIntegerDictionaryEncodingEnabled(boolean integerDictionaryEncodingEnabled) {
            this.integerDictionaryEncodingEnabled = integerDictionaryEncodingEnabled;
            return this;
        }

        public Builder withStringDictionarySortingEnabled(boolean stringDictionarySortingEnabled) {
            this.stringDictionarySortingEnabled = stringDictionarySortingEnabled;
            return this;
        }

        public Builder withStringDictionaryEncodingEnabled(boolean stringDictionaryEncodingEnabled) {
            this.stringDictionaryEncodingEnabled = stringDictionaryEncodingEnabled;
            return this;
        }

        public Builder withDwrfStripeCacheEnabled(boolean dwrfStripeCacheEnabled) {
            this.dwrfStripeCacheEnabled = dwrfStripeCacheEnabled;
            return this;
        }

        public Builder withDwrfStripeCacheMode(DwrfStripeCacheMode dwrfStripeCacheMode) {
            this.dwrfStripeCacheMode = Objects.requireNonNull(dwrfStripeCacheMode, "dwrfStripeCacheMode is null");
            return this;
        }

        public Builder withDwrfStripeCacheMaxSize(DataSize dwrfStripeCacheMaxSize) {
            this.dwrfStripeCacheMaxSize = Objects.requireNonNull(dwrfStripeCacheMaxSize, "dwrfStripeCacheMaxSize is null");
            return this;
        }

        public Builder withIgnoreDictionaryRowGroupSizes(boolean ignoreDictionaryRowGroupSizes) {
            this.ignoreDictionaryRowGroupSizes = ignoreDictionaryRowGroupSizes;
            return this;
        }

        public Builder withPreserveDirectEncodingStripeCount(int preserveDirectEncodingStripeCount) {
            this.preserveDirectEncodingStripeCount = preserveDirectEncodingStripeCount;
            return this;
        }

        public Builder withFlattenedColumns(Set<Integer> flattenedColumns) {
            this.flattenedColumns = ImmutableSet.copyOf(flattenedColumns);
            return this;
        }

        public Builder withMapStatisticsEnabled(boolean mapStatisticsEnabled) {
            this.mapStatisticsEnabled = mapStatisticsEnabled;
            return this;
        }

        public Builder withMaxFlattenedMapKeyCount(int maxFlattenedMapKeyCount) {
            this.maxFlattenedMapKeyCount = maxFlattenedMapKeyCount;
            return this;
        }

        public OrcWriterOptions build() {
            Optional<Object> dwrfWriterOptions = this.dwrfStripeCacheEnabled ? Optional.of(new DwrfStripeCacheOptions(this.dwrfStripeCacheMode, this.dwrfStripeCacheMaxSize)) : Optional.empty();
            return new OrcWriterOptions(this.flushPolicy, this.rowGroupMaxRowCount, this.dictionaryMaxMemory, this.dictionaryMemoryAlmostFullRange, this.dictionaryUsefulCheckPerChunkFrequency, this.dictionaryUsefulCheckColumnSize, this.maxStringStatisticsLimit, this.maxCompressionBufferSize, this.compressionLevel, this.streamLayoutFactory, this.integerDictionaryEncodingEnabled, this.stringDictionarySortingEnabled, this.stringDictionaryEncodingEnabled, dwrfWriterOptions, this.ignoreDictionaryRowGroupSizes, this.preserveDirectEncodingStripeCount, this.flattenedColumns, this.mapStatisticsEnabled, this.maxFlattenedMapKeyCount);
        }
    }
}

