/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.BinaryStatistics;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.HiveBloomFilter;
import com.facebook.presto.orc.metadata.statistics.StatisticsHasher;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class BinaryColumnStatistics
extends ColumnStatistics {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BinaryColumnStatistics.class).instanceSize();
    private final BinaryStatistics binaryStatistics;

    public BinaryColumnStatistics(Long numberOfValues, HiveBloomFilter bloomFilter, Long rawSize, Long storageSize, BinaryStatistics binaryStatistics) {
        super(numberOfValues, bloomFilter, rawSize, storageSize);
        Objects.requireNonNull(binaryStatistics, "binaryStatistics is null");
        this.binaryStatistics = binaryStatistics;
    }

    @Override
    public BinaryStatistics getBinaryStatistics() {
        return this.binaryStatistics;
    }

    @Override
    public long getTotalValueSizeInBytes() {
        return 5L * this.getNumberOfValues() + this.binaryStatistics.getSum();
    }

    @Override
    public long getRetainedSizeInBytes() {
        long sizeInBytes = (long)INSTANCE_SIZE + super.getMembersSizeInBytes();
        return sizeInBytes + this.binaryStatistics.getRetainedSizeInBytes();
    }

    @Override
    public void addHash(StatisticsHasher hasher) {
        super.addHash(hasher);
        hasher.putOptionalHashable(this.binaryStatistics);
    }

    @Override
    protected MoreObjects.ToStringHelper getToStringHelper() {
        return super.getToStringHelper().add("binaryStatistics", (Object)this.binaryStatistics);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryColumnStatistics that = (BinaryColumnStatistics)o;
        return this.equalsInternal(that) && Objects.equals(this.binaryStatistics, that.binaryStatistics);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.binaryStatistics);
    }
}

