/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.orc.metadata.statistics.BinaryColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.BinaryStatistics;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.SliceColumnStatisticsBuilder;
import com.google.common.base.Verify;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class BinaryStatisticsBuilder
implements SliceColumnStatisticsBuilder {
    private long nonNullValueCount;
    private long storageSize;
    private long rawSize;
    private long sum;

    @Override
    public void addValue(Block block, int position) {
        Objects.requireNonNull(block, "block is null");
        this.sum += (long)block.getSliceLength(position);
        ++this.nonNullValueCount;
    }

    private Optional<BinaryStatistics> buildBinaryStatistics() {
        if (this.nonNullValueCount == 0L) {
            return Optional.empty();
        }
        return Optional.of(new BinaryStatistics(this.sum));
    }

    private void addBinaryStatistics(long valueCount, BinaryStatistics value) {
        Objects.requireNonNull(value, "value is null");
        this.nonNullValueCount += valueCount;
        this.sum += value.getSum();
    }

    @Override
    public ColumnStatistics buildColumnStatistics() {
        Optional<BinaryStatistics> binaryStatistics = this.buildBinaryStatistics();
        if (binaryStatistics.isPresent()) {
            Verify.verify((this.nonNullValueCount > 0L ? 1 : 0) != 0);
            return new BinaryColumnStatistics(this.nonNullValueCount, null, this.rawSize, this.storageSize, binaryStatistics.get());
        }
        return new ColumnStatistics(this.nonNullValueCount, null, this.rawSize, this.storageSize);
    }

    @Override
    public void incrementRawSize(long rawSize) {
        this.rawSize += rawSize;
    }

    @Override
    public void incrementSize(long storageSize) {
        this.storageSize += storageSize;
    }

    public static Optional<BinaryStatistics> mergeBinaryStatistics(List<ColumnStatistics> stats) {
        BinaryStatisticsBuilder binaryStatisticsBuilder = new BinaryStatisticsBuilder();
        for (ColumnStatistics columnStatistics : stats) {
            BinaryStatistics partialStatistics = columnStatistics.getBinaryStatistics();
            if (columnStatistics.getNumberOfValues() <= 0L) continue;
            if (partialStatistics == null) {
                return Optional.empty();
            }
            binaryStatisticsBuilder.addBinaryStatistics(columnStatistics.getNumberOfValues(), partialStatistics);
        }
        return binaryStatisticsBuilder.buildBinaryStatistics();
    }
}

