/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.DateStatistics;
import com.facebook.presto.orc.metadata.statistics.HiveBloomFilter;
import com.facebook.presto.orc.metadata.statistics.StatisticsHasher;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class DateColumnStatistics
extends ColumnStatistics {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DateColumnStatistics.class).instanceSize();
    private final DateStatistics dateStatistics;

    public DateColumnStatistics(Long numberOfValues, HiveBloomFilter bloomFilter, Long rawSize, Long storageSize, DateStatistics dateStatistics) {
        super(numberOfValues, bloomFilter, rawSize, storageSize);
        Objects.requireNonNull(dateStatistics, "dateStatistics is null");
        this.dateStatistics = dateStatistics;
    }

    @Override
    public DateStatistics getDateStatistics() {
        return this.dateStatistics;
    }

    @Override
    public long getTotalValueSizeInBytes() {
        return this.getNumberOfValues() * 5L;
    }

    @Override
    public long getRetainedSizeInBytes() {
        long sizeInBytes = (long)INSTANCE_SIZE + this.getMembersSizeInBytes();
        return sizeInBytes + this.dateStatistics.getRetainedSizeInBytes();
    }

    @Override
    public void addHash(StatisticsHasher hasher) {
        super.addHash(hasher);
        hasher.putOptionalHashable(this.dateStatistics);
    }

    @Override
    protected MoreObjects.ToStringHelper getToStringHelper() {
        return super.getToStringHelper().add("dateStatistics", (Object)this.dateStatistics);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateColumnStatistics that = (DateColumnStatistics)o;
        return this.equalsInternal(that) && Objects.equals(this.dateStatistics, that.dateStatistics);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dateStatistics);
    }
}

