/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.DecimalStatistics;
import com.facebook.presto.orc.metadata.statistics.HiveBloomFilter;
import com.facebook.presto.orc.metadata.statistics.StatisticsHasher;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class DecimalColumnStatistics
extends ColumnStatistics {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DecimalColumnStatistics.class).instanceSize();
    private final DecimalStatistics decimalStatistics;

    public DecimalColumnStatistics(Long numberOfValues, HiveBloomFilter bloomFilter, Long rawSize, Long storageSize, DecimalStatistics decimalStatistics) {
        super(numberOfValues, bloomFilter, rawSize, storageSize);
        Objects.requireNonNull(decimalStatistics, "decimalStatistics is null");
        this.decimalStatistics = decimalStatistics;
    }

    @Override
    public DecimalStatistics getDecimalStatistics() {
        return this.decimalStatistics;
    }

    @Override
    public long getTotalValueSizeInBytes() {
        return this.getNumberOfValues() * this.decimalStatistics.getMinAverageValueSizeInBytes();
    }

    @Override
    public long getRetainedSizeInBytes() {
        long sizeInBytes = (long)INSTANCE_SIZE + this.getMembersSizeInBytes();
        return sizeInBytes + this.decimalStatistics.getRetainedSizeInBytes();
    }

    @Override
    public void addHash(StatisticsHasher hasher) {
        super.addHash(hasher);
        hasher.putOptionalHashable(this.decimalStatistics);
    }

    @Override
    protected MoreObjects.ToStringHelper getToStringHelper() {
        return super.getToStringHelper().add("decimalStatistics", (Object)this.decimalStatistics);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecimalColumnStatistics that = (DecimalColumnStatistics)o;
        return this.equalsInternal(that) && Objects.equals(this.decimalStatistics, that.decimalStatistics);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.decimalStatistics);
    }
}

