/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.StatisticsHasher;
import com.facebook.presto.orc.proto.DwrfProto;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class MapStatisticsEntry
implements StatisticsHasher.Hashable {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapStatisticsEntry.class).instanceSize();
    private static final int KEY_INSTANCE_SIZE = ClassLayout.parseClass(DwrfProto.KeyInfo.class).instanceSize();
    private final DwrfProto.KeyInfo key;
    private final ColumnStatistics columnStatistics;

    public MapStatisticsEntry(DwrfProto.KeyInfo key, ColumnStatistics columnStatistics) {
        this.key = Objects.requireNonNull(key, "key is null");
        this.columnStatistics = Objects.requireNonNull(columnStatistics, "columnStatistics is null");
    }

    public DwrfProto.KeyInfo getKey() {
        return this.key;
    }

    public ColumnStatistics getColumnStatistics() {
        return this.columnStatistics;
    }

    public long getRetainedSizeInBytes() {
        long keySize = KEY_INSTANCE_SIZE;
        if (this.key.hasBytesKey()) {
            keySize += (long)(1 * this.key.getBytesKey().size());
        }
        return (long)INSTANCE_SIZE + keySize + this.columnStatistics.getRetainedSizeInBytes();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapStatisticsEntry that = (MapStatisticsEntry)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.columnStatistics, that.columnStatistics);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.columnStatistics);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", this.key.hasBytesKey() ? this.key.getBytesKey() : Long.valueOf(this.key.getIntKey())).add("columnStatistics", (Object)this.columnStatistics).toString();
    }

    @Override
    public void addHash(StatisticsHasher hasher) {
        if (this.key.hasBytesKey()) {
            hasher.putBytes(this.key.getBytesKey().asReadOnlyByteBuffer());
        } else {
            hasher.putLong(this.key.getIntKey());
        }
        hasher.putOptionalHashable(this.columnStatistics);
    }
}

