/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.statistics.BinaryStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.BooleanStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.CountStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.DoubleStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.IntegerStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.StatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.StringStatisticsBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class StatisticsBuilders {
    private StatisticsBuilders() {
    }

    public static Supplier<StatisticsBuilder> createStatisticsBuilderSupplier(OrcType orcType, ColumnWriterOptions columnWriterOptions) {
        Objects.requireNonNull(orcType, "orcType is null");
        Objects.requireNonNull(columnWriterOptions, "columnWriterOptions is null");
        switch (orcType.getOrcTypeKind()) {
            case BOOLEAN: {
                return BooleanStatisticsBuilder::new;
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return IntegerStatisticsBuilder::new;
            }
            case FLOAT: 
            case DOUBLE: {
                return DoubleStatisticsBuilder::new;
            }
            case BINARY: {
                return BinaryStatisticsBuilder::new;
            }
            case VARCHAR: 
            case STRING: {
                int stringStatisticsLimit = columnWriterOptions.getStringStatisticsLimit();
                return () -> new StringStatisticsBuilder(stringStatisticsLimit);
            }
            case TIMESTAMP: 
            case TIMESTAMP_MICROSECONDS: 
            case LIST: 
            case MAP: 
            case STRUCT: {
                return CountStatisticsBuilder::new;
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + orcType);
    }

    public static Map<Integer, ColumnStatistics> createEmptyColumnStatistics(List<OrcType> orcTypes, int nodeIndex, ColumnWriterOptions columnWriterOptions) {
        Objects.requireNonNull(orcTypes, "orcTypes is null");
        Preconditions.checkArgument((nodeIndex >= 0 ? 1 : 0) != 0, (String)"Invalid nodeIndex value: %s", (int)nodeIndex);
        ImmutableMap.Builder columnStatistics = ImmutableMap.builder();
        LinkedList<Integer> stack = new LinkedList<Integer>();
        stack.add(nodeIndex);
        while (!stack.isEmpty()) {
            int node = (Integer)stack.removeLast();
            OrcType orcType = orcTypes.get(node);
            stack.addAll(orcType.getFieldTypeIndexes());
            StatisticsBuilder statisticsBuilder = StatisticsBuilders.createStatisticsBuilderSupplier(orcType, columnWriterOptions).get();
            ColumnStatistics emptyStatistics = statisticsBuilder.buildColumnStatistics();
            columnStatistics.put((Object)node, (Object)emptyStatistics);
        }
        return columnStatistics.build();
    }
}

