/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.common.array.Arrays;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.DictionaryCompressionOptimizer;
import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.checkpoint.StreamCheckpoint;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressedMetadataWriter;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.stream.LongOutputStream;
import com.facebook.presto.orc.stream.PresentOutputStream;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.facebook.presto.orc.writer.ColumnWriterUtils;
import com.facebook.presto.orc.writer.DictionaryRowGroup;
import com.facebook.presto.orc.writer.DictionaryRowGroupBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;

public abstract class DictionaryColumnWriter
implements ColumnWriter,
DictionaryCompressionOptimizer.DictionaryColumn {
    public static final int NUMBER_OF_NULLS_PER_BYTE = 8;
    private static final int EXPECTED_ROW_GROUP_SEGMENT_SIZE = 10000;
    protected final int column;
    protected final int sequence;
    protected final ColumnWriterOptions columnWriterOptions;
    protected final Optional<DwrfDataEncryptor> dwrfEncryptor;
    protected final OrcEncoding orcEncoding;
    protected final MetadataWriter metadataWriter;
    protected long rawSize;
    private final CompressedMetadataWriter compressedMetadataWriter;
    private final List<DictionaryRowGroup> rowGroups = new ArrayList<DictionaryRowGroup>();
    private final DictionaryRowGroupBuilder rowGroupBuilder = new DictionaryRowGroupBuilder();
    private final int preserveDirectEncodingStripeCount;
    private PresentOutputStream presentStream;
    private LongOutputStream dataStream;
    private int[] rowGroupIndexes;
    private int rowGroupOffset;
    private long rawBytesEstimate;
    private long totalValueCount;
    private long totalNonNullValueCount;
    private boolean closed;
    private boolean inRowGroup;
    private boolean directEncoded;
    private long rowGroupRetainedSizeInBytes;
    private int preserveDirectEncodingStripeIndex;

    public DictionaryColumnWriter(int column, int sequence, ColumnWriterOptions columnWriterOptions, Optional<DwrfDataEncryptor> dwrfEncryptor, OrcEncoding orcEncoding, MetadataWriter metadataWriter) {
        Preconditions.checkArgument((column >= 0 ? 1 : 0) != 0, (Object)"column is negative");
        Preconditions.checkArgument((sequence >= 0 ? 1 : 0) != 0, (Object)"sequence is negative");
        this.column = column;
        this.sequence = sequence;
        this.columnWriterOptions = Objects.requireNonNull(columnWriterOptions, "columnWriterOptions is null");
        this.dwrfEncryptor = Objects.requireNonNull(dwrfEncryptor, "dwrfEncryptor is null");
        this.orcEncoding = Objects.requireNonNull(orcEncoding, "orcEncoding is null");
        this.compressedMetadataWriter = new CompressedMetadataWriter(metadataWriter, columnWriterOptions, dwrfEncryptor);
        this.preserveDirectEncodingStripeCount = columnWriterOptions.getPreserveDirectEncodingStripeCount();
        this.dataStream = LongOutputStream.createDataOutputStream(columnWriterOptions, dwrfEncryptor, orcEncoding);
        this.presentStream = new PresentOutputStream(columnWriterOptions, dwrfEncryptor);
        this.metadataWriter = Objects.requireNonNull(metadataWriter, "metadataWriter is null");
        this.rowGroupIndexes = new int[10000];
    }

    protected abstract ColumnWriter createDirectColumnWriter();

    protected abstract ColumnWriter getDirectColumnWriter();

    protected abstract boolean tryConvertRowGroupToDirect(int var1, int[] var2, int var3);

    protected abstract boolean tryConvertRowGroupToDirect(int var1, short[] var2, int var3);

    protected abstract boolean tryConvertRowGroupToDirect(int var1, byte[] var2, int var3);

    protected abstract ColumnEncoding getDictionaryColumnEncoding();

    protected abstract BlockStatistics addBlockToDictionary(Block var1, int var2, int[] var3);

    protected abstract long getRetainedDictionaryBytes();

    protected abstract Optional<int[]> writeDictionary();

    protected abstract void beginDataRowGroup();

    protected abstract void movePresentStreamToDirectWriter(PresentOutputStream var1);

    protected abstract void updateRawSizeInDirectWriter(long var1);

    protected abstract void writeDataStreams(int var1, byte[] var2, Optional<int[]> var3, LongOutputStream var4);

    protected abstract void writeDataStreams(int var1, short[] var2, Optional<int[]> var3, LongOutputStream var4);

    protected abstract void writeDataStreams(int var1, int[] var2, Optional<int[]> var3, LongOutputStream var4);

    protected abstract void resetDictionary();

    protected abstract void closeDictionary();

    protected abstract List<StreamDataOutput> getDictionaryStreams(int var1, int var2);

    protected abstract ColumnStatistics createColumnStatistics();

    @Override
    public long getRawBytesEstimate() {
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        return this.rawBytesEstimate;
    }

    @Override
    public boolean isDirectEncoded() {
        return this.directEncoded;
    }

    @Override
    public int getIndexBytes() {
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        return Math.toIntExact((long)DictionaryCompressionOptimizer.estimateIndexBytesPerValue(this.getDictionaryEntries()) * this.getNonNullValueCount());
    }

    @Override
    public long getValueCount() {
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        return this.totalValueCount;
    }

    @Override
    public long getNonNullValueCount() {
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        return this.totalNonNullValueCount;
    }

    @Override
    public long getNullValueCount() {
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        return this.totalValueCount - this.totalNonNullValueCount;
    }

    private boolean tryConvertRowGroupToDirect(byte[][] byteSegments, short[][] shortSegments, int[][] intSegments, int maxDirectBytes) {
        if (byteSegments != null) {
            for (byte[] byteIndexes : byteSegments) {
                if (this.tryConvertRowGroupToDirect(byteIndexes.length, byteIndexes, maxDirectBytes)) continue;
                return false;
            }
        }
        if (shortSegments != null) {
            for (short[] shortIndexes : shortSegments) {
                if (this.tryConvertRowGroupToDirect(shortIndexes.length, shortIndexes, maxDirectBytes)) continue;
                return false;
            }
        }
        if (intSegments != null) {
            for (int[] intIndexes : intSegments) {
                if (this.tryConvertRowGroupToDirect(intIndexes.length, intIndexes, maxDirectBytes)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public OptionalInt tryConvertToDirect(int maxDirectBytes) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        ColumnWriter directWriter = this.createDirectColumnWriter();
        Preconditions.checkState((directWriter.getBufferedBytes() == 0L ? 1 : 0) != 0, (Object)"direct writer should have no data");
        for (DictionaryRowGroup rowGroup : this.rowGroups) {
            this.beginDataRowGroup();
            boolean success = this.tryConvertRowGroupToDirect(rowGroup.getByteSegments(), rowGroup.getShortSegments(), rowGroup.getIntSegments(), maxDirectBytes);
            if (!success) {
                return this.resetDirectWriter(directWriter);
            }
            this.updateRawSizeInDirectWriter(rowGroup.getColumnStatistics().getRawSize());
            directWriter.finishRowGroup();
        }
        if (this.inRowGroup) {
            this.beginDataRowGroup();
            boolean success = this.tryConvertRowGroupToDirect(this.rowGroupBuilder.getByteSegments(), this.rowGroupBuilder.getShortSegments(), this.rowGroupBuilder.getIntegerSegments(), maxDirectBytes);
            if (!success) {
                return this.resetDirectWriter(directWriter);
            }
            if (!this.tryConvertRowGroupToDirect(this.rowGroupOffset, this.rowGroupIndexes, maxDirectBytes)) {
                return this.resetDirectWriter(directWriter);
            }
        } else {
            Preconditions.checkState((this.rowGroupOffset == 0 ? 1 : 0) != 0);
        }
        this.movePresentStreamToDirectWriter(this.presentStream);
        this.updateRawSizeInDirectWriter(this.rawSize);
        this.presentStream = new PresentOutputStream(this.columnWriterOptions, this.dwrfEncryptor);
        this.rawBytesEstimate = 0L;
        this.totalValueCount = 0L;
        this.totalNonNullValueCount = 0L;
        this.resetRowGroups();
        this.closeDictionary();
        this.resetDictionary();
        this.directEncoded = true;
        return OptionalInt.of(Math.toIntExact(directWriter.getBufferedBytes()));
    }

    private OptionalInt resetDirectWriter(ColumnWriter directWriter) {
        directWriter.close();
        directWriter.reset();
        return OptionalInt.empty();
    }

    @Override
    public Map<Integer, ColumnEncoding> getColumnEncodings() {
        Preconditions.checkState((boolean)this.closed);
        if (this.directEncoded) {
            return this.getDirectColumnWriter().getColumnEncodings();
        }
        return ImmutableMap.of((Object)this.column, (Object)this.getDictionaryColumnEncoding());
    }

    @Override
    public void beginRowGroup() {
        Preconditions.checkState((!this.inRowGroup ? 1 : 0) != 0);
        this.inRowGroup = true;
        if (this.directEncoded) {
            this.getDirectColumnWriter().beginRowGroup();
        } else {
            this.presentStream.recordCheckpoint();
        }
    }

    @Override
    public long writeBlock(Block block) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((block.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"Block is empty");
        if (this.directEncoded) {
            return this.getDirectColumnWriter().writeBlock(block);
        }
        this.rowGroupIndexes = Arrays.ensureCapacity((int[])this.rowGroupIndexes, (int)(this.rowGroupOffset + block.getPositionCount()), (Arrays.ExpansionFactor)Arrays.ExpansionFactor.MEDIUM, (Arrays.ExpansionOption)Arrays.ExpansionOption.PRESERVE);
        for (int position = 0; position < block.getPositionCount(); ++position) {
            this.presentStream.writeBoolean(!block.isNull(position));
        }
        BlockStatistics blockStatistics = this.addBlockToDictionary(block, this.rowGroupOffset, this.rowGroupIndexes);
        this.totalNonNullValueCount += (long)blockStatistics.getNonNullValueCount();
        this.rawBytesEstimate += blockStatistics.getRawBytesEstimate();
        this.rowGroupOffset += blockStatistics.getNonNullValueCount();
        this.totalValueCount += (long)block.getPositionCount();
        if (this.rowGroupOffset >= 10000) {
            this.rowGroupBuilder.addIndexes(this.getDictionaryEntries() - 1, this.rowGroupIndexes, this.rowGroupOffset);
            this.rowGroupOffset = 0;
        }
        long rawSize = blockStatistics.getRawBytesIncludingNulls();
        this.rawSize += rawSize;
        return rawSize;
    }

    @Override
    public Map<Integer, ColumnStatistics> finishRowGroup() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.inRowGroup);
        this.inRowGroup = false;
        if (this.directEncoded) {
            return this.getDirectColumnWriter().finishRowGroup();
        }
        ColumnStatistics statistics = this.createColumnStatistics();
        this.rowGroupBuilder.addIndexes(this.getDictionaryEntries() - 1, this.rowGroupIndexes, this.rowGroupOffset);
        DictionaryRowGroup rowGroup = this.rowGroupBuilder.build(statistics);
        this.rowGroups.add(rowGroup);
        if (this.columnWriterOptions.isIgnoreDictionaryRowGroupSizes()) {
            this.rowGroupRetainedSizeInBytes += rowGroup.getColumnStatistics().getRetainedSizeInBytes();
        } else {
            this.rowGroupRetainedSizeInBytes += rowGroup.getShallowRetainedSizeInBytes();
            this.rowGroupRetainedSizeInBytes += (long)this.rowGroupBuilder.getIndexRetainedBytes();
        }
        this.rowGroupOffset = 0;
        this.rowGroupBuilder.reset();
        this.rawSize = 0L;
        return ImmutableMap.of((Object)this.column, (Object)statistics);
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((!this.inRowGroup ? 1 : 0) != 0);
        this.closed = true;
        if (this.directEncoded) {
            this.getDirectColumnWriter().close();
        } else {
            this.bufferOutputData();
        }
    }

    @Override
    public Map<Integer, ColumnStatistics> getColumnStripeStatistics() {
        Preconditions.checkState((boolean)this.closed);
        if (this.directEncoded) {
            return this.getDirectColumnWriter().getColumnStripeStatistics();
        }
        return ImmutableMap.of((Object)this.column, (Object)ColumnStatistics.mergeColumnStatistics(this.rowGroups.stream().map(DictionaryRowGroup::getColumnStatistics).collect(Collectors.toList())));
    }

    private void bufferOutputData() {
        Preconditions.checkState((boolean)this.closed);
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        Optional<int[]> originalDictionaryToSortedIndex = this.writeDictionary();
        if (!this.rowGroups.isEmpty()) {
            this.dataStream.recordCheckpoint();
        }
        for (DictionaryRowGroup rowGroup : this.rowGroups) {
            int[][] intSegments;
            short[][] shortSegments;
            byte[][] byteSegments = rowGroup.getByteSegments();
            if (byteSegments != null) {
                for (byte[] byteIndexes : byteSegments) {
                    this.writeDataStreams(byteIndexes.length, byteIndexes, originalDictionaryToSortedIndex, this.dataStream);
                }
            }
            if ((shortSegments = rowGroup.getShortSegments()) != null) {
                for (short[] shortIndexes : shortSegments) {
                    this.writeDataStreams(shortIndexes.length, shortIndexes, originalDictionaryToSortedIndex, this.dataStream);
                }
            }
            if ((intSegments = rowGroup.getIntSegments()) != null) {
                for (int[] integerIndexes : intSegments) {
                    this.writeDataStreams(integerIndexes.length, integerIndexes, originalDictionaryToSortedIndex, this.dataStream);
                }
            }
            this.dataStream.recordCheckpoint();
        }
        this.closeDictionary();
        this.dataStream.close();
        this.presentStream.close();
    }

    @Override
    public List<StreamDataOutput> getIndexStreams(Optional<List<? extends StreamCheckpoint>> prependCheckpoints) throws IOException {
        Preconditions.checkState((boolean)this.closed);
        if (this.directEncoded) {
            return this.getDirectColumnWriter().getIndexStreams(prependCheckpoints);
        }
        boolean compressed = this.columnWriterOptions.getCompressionKind() != CompressionKind.NONE;
        List<ColumnStatistics> rowGroupColumnStatistics = this.rowGroups.stream().map(DictionaryRowGroup::getColumnStatistics).collect(Collectors.toList());
        List<RowGroupIndex> rowGroupIndexes = ColumnWriterUtils.buildRowGroupIndexes(compressed, rowGroupColumnStatistics, prependCheckpoints, this.presentStream, this.dataStream);
        Slice slice = this.compressedMetadataWriter.writeRowIndexes(rowGroupIndexes);
        Stream stream = new Stream(this.column, this.sequence, Stream.StreamKind.ROW_INDEX, slice.length(), false);
        return ImmutableList.of((Object)new StreamDataOutput(slice, stream));
    }

    @Override
    public List<StreamDataOutput> getDataStreams() {
        Preconditions.checkState((boolean)this.closed);
        if (this.directEncoded) {
            return this.getDirectColumnWriter().getDataStreams();
        }
        ImmutableList.Builder outputDataStreams = ImmutableList.builder();
        this.presentStream.getStreamDataOutput(this.column, this.sequence).ifPresent(arg_0 -> ((ImmutableList.Builder)outputDataStreams).add(arg_0));
        outputDataStreams.add((Object)this.dataStream.getStreamDataOutput(this.column, this.sequence));
        outputDataStreams.addAll(this.getDictionaryStreams(this.column, this.sequence));
        return outputDataStreams.build();
    }

    @Override
    public long getBufferedBytes() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        if (this.directEncoded) {
            return this.getDirectColumnWriter().getBufferedBytes();
        }
        long numberOfNullBytes = this.getNullValueCount() / 8L;
        return (long)(this.getIndexBytes() + this.getDictionaryBytes()) + numberOfNullBytes;
    }

    @VisibleForTesting
    public long getRowGroupRetainedSizeInBytes() {
        return this.rowGroupRetainedSizeInBytes;
    }

    @Override
    public long getRetainedBytes() {
        return SizeOf.sizeOf((int[])this.rowGroupIndexes) + this.rowGroupBuilder.getRetainedSizeInBytes() + this.dataStream.getRetainedBytes() + this.presentStream.getRetainedBytes() + this.getRetainedDictionaryBytes() + this.rowGroupRetainedSizeInBytes;
    }

    private void resetRowGroups() {
        this.rowGroups.clear();
        this.rowGroupBuilder.reset();
        this.rowGroupRetainedSizeInBytes = 0L;
        this.rowGroupOffset = 0;
    }

    @Override
    public void reset() {
        Preconditions.checkState((boolean)this.closed);
        this.closed = false;
        this.presentStream.reset();
        this.dataStream = LongOutputStream.createDataOutputStream(this.columnWriterOptions, this.dwrfEncryptor, this.orcEncoding);
        this.resetDictionary();
        this.resetRowGroups();
        this.rawBytesEstimate = 0L;
        this.totalValueCount = 0L;
        this.totalNonNullValueCount = 0L;
        this.rawSize = 0L;
        if (this.directEncoded) {
            this.getDirectColumnWriter().reset();
            if (this.preserveDirectEncodingStripeIndex >= this.preserveDirectEncodingStripeCount) {
                this.directEncoded = false;
                this.preserveDirectEncodingStripeIndex = 0;
            } else {
                ++this.preserveDirectEncodingStripeIndex;
            }
        }
    }

    static class BlockStatistics {
        private final int nonNullValueCount;
        private final long rawBytesEstimate;
        private final long rawBytesIncludingNulls;

        public BlockStatistics(int nonNullValueCount, long rawBytesEstimate, long rawBytesIncludingNulls) {
            this.nonNullValueCount = nonNullValueCount;
            this.rawBytesEstimate = rawBytesEstimate;
            this.rawBytesIncludingNulls = rawBytesIncludingNulls;
        }

        public int getNonNullValueCount() {
            return this.nonNullValueCount;
        }

        public long getRawBytesEstimate() {
            return this.rawBytesEstimate;
        }

        public long getRawBytesIncludingNulls() {
            return this.rawBytesIncludingNulls;
        }
    }
}

