/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.common.array.Arrays;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.ColumnarMap;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.FixedWidthType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.checkpoint.StreamCheckpoint;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressedMetadataWriter;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.DwrfSequenceEncoding;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.MapColumnStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.StatisticsBuilder;
import com.facebook.presto.orc.proto.DwrfProto;
import com.facebook.presto.orc.protobuf.ByteString;
import com.facebook.presto.orc.stream.PresentOutputStream;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.stream.ValueOutputStream;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.facebook.presto.orc.writer.ColumnWriterUtils;
import com.facebook.presto.orc.writer.MapFlatValueWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.openjdk.jol.info.ClassLayout;

public class MapFlatColumnWriter
implements ColumnWriter {
    private static final int SEQUENCE_START_INDEX = 1;
    private static final ColumnEncoding FLAT_MAP_COLUMN_ENCODING = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DWRF_MAP_FLAT, 0);
    private static final DwrfProto.KeyInfo EMPTY_SLICE_KEY = DwrfProto.KeyInfo.newBuilder().setBytesKey(ByteString.EMPTY).build();
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapFlatColumnWriter.class).instanceSize();
    private static final int MIN_CAPACITY = 16;
    private final int nodeIndex;
    private final int keyNodeIndex;
    private final int valueNodeIndex;
    private final Type keyType;
    private final ColumnWriterOptions columnWriterOptions;
    private final Optional<DwrfDataEncryptor> dwrfEncryptor;
    private final boolean compressed;
    private final PresentOutputStream presentStream;
    private final CompressedMetadataWriter metadataWriter;
    private final KeyManager keyManager;
    private final int maxFlattenedMapKeyCount;
    private final boolean mapStatsEnabled;
    private final Block nullValueBlock;
    private final List<MapFlatValueWriter> valueWriters = new ArrayList<MapFlatValueWriter>();
    private final IntFunction<ColumnWriter> valueWriterFactory;
    private final Supplier<Map<Integer, ColumnStatistics>> emptyValueColumnStatisticsSupplier;
    private final IntList rowsInFinishedRowGroups = new IntArrayList();
    private final List<ColumnStatistics> rowGroupColumnStatistics = new ArrayList<ColumnStatistics>();
    private boolean closed;
    private int nonNullRowGroupValueCount;
    private int nonNullStripeValueCount;
    private int[] valueWritersLastRow = new int[0];
    private Map<Integer, ColumnStatistics> emptyValueColumnStatistics;
    private long rawSize;
    private long stripeRawSize;

    public MapFlatColumnWriter(int nodeIndex, int keyNodeIndex, int valueNodeIndex, Type keyType, Type valueType, Supplier<StatisticsBuilder> keyStatisticsBuilderSupplier, ColumnWriterOptions columnWriterOptions, Optional<DwrfDataEncryptor> dwrfEncryptor, MetadataWriter metadataWriter, IntFunction<ColumnWriter> valueWriterFactory, Supplier<Map<Integer, ColumnStatistics>> emptyValueColumnStatisticsSupplier) {
        Preconditions.checkArgument((nodeIndex > 0 ? 1 : 0) != 0, (String)"nodeIndex is invalid: %s", (int)nodeIndex);
        Preconditions.checkArgument((keyNodeIndex > 0 ? 1 : 0) != 0, (String)"keyNodeIndex is invalid: %s", (int)keyNodeIndex);
        Preconditions.checkArgument((valueNodeIndex > 0 ? 1 : 0) != 0, (String)"valueNodeIndex is invalid: %s", (int)valueNodeIndex);
        Objects.requireNonNull(keyStatisticsBuilderSupplier, "keyStatisticsBuilderSupplier is null");
        Preconditions.checkArgument((columnWriterOptions.getMaxFlattenedMapKeyCount() > 0 ? 1 : 0) != 0, (String)"maxFlattenedMapKeyCount must be positive: %s", (int)columnWriterOptions.getMaxFlattenedMapKeyCount());
        this.nodeIndex = nodeIndex;
        this.keyNodeIndex = keyNodeIndex;
        this.valueNodeIndex = valueNodeIndex;
        this.keyType = Objects.requireNonNull(keyType, "keyType is null");
        this.nullValueBlock = MapFlatColumnWriter.createNullValueBlock(Objects.requireNonNull(valueType, "valueType is null"));
        this.maxFlattenedMapKeyCount = columnWriterOptions.getMaxFlattenedMapKeyCount();
        this.mapStatsEnabled = columnWriterOptions.isMapStatisticsEnabled();
        this.columnWriterOptions = Objects.requireNonNull(columnWriterOptions, "columnWriterOptions is null");
        this.dwrfEncryptor = Objects.requireNonNull(dwrfEncryptor, "dwrfEncryptor is null");
        this.keyManager = this.getKeyManager(keyType, keyStatisticsBuilderSupplier);
        this.valueWriterFactory = Objects.requireNonNull(valueWriterFactory, "valueWriterFactory is null");
        this.emptyValueColumnStatisticsSupplier = Objects.requireNonNull(emptyValueColumnStatisticsSupplier, "emptyValueColumnStatisticsSupplier is null");
        this.compressed = columnWriterOptions.getCompressionKind() != CompressionKind.NONE;
        this.metadataWriter = new CompressedMetadataWriter(metadataWriter, columnWriterOptions, dwrfEncryptor);
        this.presentStream = new PresentOutputStream(columnWriterOptions, dwrfEncryptor);
    }

    @Override
    public List<ColumnWriter> getNestedColumnWriters() {
        ImmutableList.Builder nestedWriters = ImmutableList.builderWithExpectedSize((int)(this.valueWriters.size() * 2));
        for (MapFlatValueWriter mapValueWriter : this.valueWriters) {
            ColumnWriter valueWriter = mapValueWriter.getValueWriter();
            nestedWriters.add((Object)valueWriter);
            nestedWriters.addAll(valueWriter.getNestedColumnWriters());
        }
        return nestedWriters.build();
    }

    @Override
    public Map<Integer, ColumnEncoding> getColumnEncodings() {
        return ImmutableMap.builder().put((Object)this.nodeIndex, (Object)FLAT_MAP_COLUMN_ENCODING).putAll(this.getValueColumnEncodings()).build();
    }

    private Map<Integer, ColumnEncoding> getValueColumnEncodings() {
        HashMap<Integer, ImmutableSortedMap.Builder> sequenceEncodingsByNode = new HashMap<Integer, ImmutableSortedMap.Builder>();
        for (MapFlatValueWriter valueWriter : this.valueWriters) {
            DwrfProto.KeyInfo dwrfKey = valueWriter.getDwrfKey();
            Integer sequence = valueWriter.getSequence();
            Map<Integer, ColumnEncoding> valueEncodings = valueWriter.getValueWriter().getColumnEncodings();
            valueEncodings.forEach((nodeIndex, valueEncoding) -> {
                ImmutableSortedMap.Builder sequenceEncodings = sequenceEncodingsByNode.computeIfAbsent((Integer)nodeIndex, ignore -> ImmutableSortedMap.naturalOrder());
                sequenceEncodings.put((Object)sequence, (Object)new DwrfSequenceEncoding(dwrfKey, (ColumnEncoding)valueEncoding));
            });
        }
        ImmutableMap.Builder columnEncoding = ImmutableMap.builder();
        sequenceEncodingsByNode.forEach((nodeIndex, sequenceEncodings) -> {
            ColumnEncoding valueEncoding = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0, Optional.of(sequenceEncodings.build()));
            columnEncoding.put(nodeIndex, (Object)valueEncoding);
        });
        return columnEncoding.build();
    }

    @Override
    public void beginRowGroup() {
        this.presentStream.recordCheckpoint();
        this.valueWriters.forEach(MapFlatValueWriter::beginRowGroup);
    }

    @Override
    public Map<Integer, ColumnStatistics> finishRowGroup() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        for (int i = 0; i < this.valueWriters.size(); ++i) {
            if (this.valueWritersLastRow[i] >= this.nonNullRowGroupValueCount) continue;
            this.valueWriters.get(i).writeNotInMap(this.nonNullRowGroupValueCount - this.valueWritersLastRow[i]);
        }
        java.util.Arrays.fill(this.valueWritersLastRow, 0);
        Map<Integer, ColumnStatistics> columnStatistics = this.getColumnStatisticsFromValueWriters(ColumnWriter::finishRowGroup, this.nonNullRowGroupValueCount, this.rawSize);
        ColumnStatistics mapStatistics = Objects.requireNonNull(columnStatistics.get(this.nodeIndex), "ColumnStatistics for the map node is missing");
        this.rowGroupColumnStatistics.add(mapStatistics);
        this.rowsInFinishedRowGroups.add(this.nonNullRowGroupValueCount);
        this.nonNullStripeValueCount += this.nonNullRowGroupValueCount;
        this.nonNullRowGroupValueCount = 0;
        this.stripeRawSize += this.rawSize;
        this.rawSize = 0L;
        return columnStatistics;
    }

    @Override
    public Map<Integer, ColumnStatistics> getColumnStripeStatistics() {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableMap.builder().put((Object)this.keyNodeIndex, (Object)this.keyManager.getStripeColumnStatistics()).putAll(this.getColumnStatisticsFromValueWriters(ColumnWriter::getColumnStripeStatistics, this.nonNullStripeValueCount, this.stripeRawSize)).build();
    }

    private Map<Integer, ColumnStatistics> getEmptyValueColumnStatistics() {
        if (this.emptyValueColumnStatistics == null) {
            this.emptyValueColumnStatistics = this.emptyValueColumnStatisticsSupplier.get();
        }
        return this.emptyValueColumnStatistics;
    }

    private Map<Integer, ColumnStatistics> getColumnStatisticsFromValueWriters(Function<ColumnWriter, Map<Integer, ColumnStatistics>> getStats, int valueCount, long rawSize) {
        MapColumnStatisticsBuilder mapStatsBuilder = new MapColumnStatisticsBuilder(this.mapStatsEnabled);
        mapStatsBuilder.increaseValueCount(valueCount);
        mapStatsBuilder.incrementRawSize(rawSize);
        if (this.valueWriters.isEmpty()) {
            return ImmutableMap.builder().put((Object)this.nodeIndex, (Object)mapStatsBuilder.buildColumnStatistics()).putAll(this.getEmptyValueColumnStatistics()).build();
        }
        ImmutableListMultimap.Builder allValueStats = ImmutableListMultimap.builder();
        for (MapFlatValueWriter valueWriter : this.valueWriters) {
            ColumnStatistics valueNodeStats;
            Map<Integer, ColumnStatistics> valueColumnStatistics = getStats.apply(valueWriter.getValueWriter());
            allValueStats.putAll(valueColumnStatistics.entrySet());
            if (!this.mapStatsEnabled || (valueNodeStats = valueColumnStatistics.get(this.valueNodeIndex)) == null) continue;
            mapStatsBuilder.addMapStatistics(valueWriter.getDwrfKey(), valueNodeStats);
        }
        ImmutableMap.Builder columnStatistics = ImmutableMap.builder();
        allValueStats.build().asMap().forEach((node, nodeStats) -> {
            ColumnStatistics mergedNodeStats = ColumnStatistics.mergeColumnStatistics((List)nodeStats);
            columnStatistics.put(node, (Object)mergedNodeStats);
        });
        columnStatistics.put((Object)this.nodeIndex, (Object)mapStatsBuilder.buildColumnStatistics());
        return columnStatistics.build();
    }

    @Override
    public long writeBlock(Block block) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((block.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"block is empty");
        ColumnarMap columnarMap = ColumnarMap.toColumnarMap((Block)block);
        Block keysBlock = columnarMap.getKeysBlock();
        Block valuesBlock = columnarMap.getValuesBlock();
        long childRawSize = 0L;
        int nonNullValueCountBefore = this.nonNullRowGroupValueCount;
        for (int position = 0; position < columnarMap.getPositionCount(); ++position) {
            boolean present = !columnarMap.isNull(position);
            this.presentStream.writeBoolean(present);
            if (!present) continue;
            int entryCount = columnarMap.getEntryCount(position);
            int entryOffset = columnarMap.getOffset(position);
            for (int i = 0; i < entryCount; ++i) {
                childRawSize += this.writeMapKeyValue(keysBlock, valuesBlock, entryOffset + i);
            }
            ++this.nonNullRowGroupValueCount;
        }
        int blockNonNullValueCount = this.nonNullRowGroupValueCount - nonNullValueCountBefore;
        long rawSize = (long)(columnarMap.getPositionCount() - blockNonNullValueCount) * 1L + childRawSize;
        this.rawSize += rawSize;
        return rawSize;
    }

    private long writeMapKeyValue(Block keysBlock, Block valuesBlock, int position) {
        Preconditions.checkArgument((!keysBlock.isNull(position) ? 1 : 0) != 0, (String)"Flat map key cannot be null. Node %s", (int)this.nodeIndex);
        MapFlatValueWriter valueWriter = this.keyManager.getOrCreateValueWriter(position, keysBlock);
        int valueWriterIdx = valueWriter.getSequence() - 1;
        if (this.valueWritersLastRow[valueWriterIdx] < this.nonNullRowGroupValueCount) {
            valueWriter.writeNotInMap(this.nonNullRowGroupValueCount - this.valueWritersLastRow[valueWriterIdx]);
        }
        this.valueWritersLastRow[valueWriterIdx] = this.nonNullRowGroupValueCount + 1;
        Block singleValueBlock = valuesBlock.isNull(position) ? this.nullValueBlock : valuesBlock.getRegion(position, 1);
        return valueWriter.writeSingleEntryBlock(singleValueBlock) + (long)valueWriter.getKeyRawSize();
    }

    @Override
    public List<StreamDataOutput> getDataStreams() {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder streams = ImmutableList.builder();
        for (MapFlatValueWriter valueWriter : this.valueWriters) {
            streams.addAll(valueWriter.getDataStreams());
        }
        this.presentStream.getStreamDataOutput(this.nodeIndex, 0).ifPresent(arg_0 -> ((ImmutableList.Builder)streams).add(arg_0));
        return streams.build();
    }

    @Override
    public List<StreamDataOutput> getIndexStreams(Optional<List<? extends StreamCheckpoint>> prependCheckpoints) throws IOException {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder streams = ImmutableList.builder();
        List<RowGroupIndex> rowGroupIndexes = ColumnWriterUtils.buildRowGroupIndexes(this.compressed, this.rowGroupColumnStatistics, prependCheckpoints, this.presentStream, new ValueOutputStream[0]);
        Slice slice = this.metadataWriter.writeRowIndexes(rowGroupIndexes);
        Stream stream = new Stream(this.nodeIndex, 0, Stream.StreamKind.ROW_INDEX, slice.length(), false);
        streams.add((Object)new StreamDataOutput(slice, stream));
        for (MapFlatValueWriter valueWriter : this.valueWriters) {
            streams.addAll(valueWriter.getIndexStreams());
        }
        return streams.build();
    }

    @Override
    public long getBufferedBytes() {
        long bufferedBytes = this.presentStream.getBufferedBytes();
        for (MapFlatValueWriter valueWriter : this.valueWriters) {
            bufferedBytes += valueWriter.getBufferedBytes();
        }
        return bufferedBytes;
    }

    @Override
    public long getRetainedBytes() {
        long retainedBytes = 0L;
        for (MapFlatValueWriter valueWriter : this.valueWriters) {
            retainedBytes += valueWriter.getValueWriter().getRetainedBytes();
        }
        return (long)INSTANCE_SIZE + retainedBytes;
    }

    @Override
    public void close() {
        this.closed = true;
        this.valueWriters.forEach(MapFlatValueWriter::close);
        this.presentStream.close();
    }

    @Override
    public void reset() {
        this.closed = false;
        this.presentStream.reset();
        this.keyManager.reset();
        this.valueWriters.clear();
        this.rowGroupColumnStatistics.clear();
        this.rowsInFinishedRowGroups.clear();
        this.nonNullRowGroupValueCount = 0;
        this.nonNullStripeValueCount = 0;
        this.rawSize = 0L;
        this.stripeRawSize = 0L;
        java.util.Arrays.fill(this.valueWritersLastRow, 0);
    }

    private MapFlatValueWriter createNewValueWriter(DwrfProto.KeyInfo dwrfKey, int keyRawSize) {
        Preconditions.checkArgument((keyRawSize >= 0 ? 1 : 0) != 0, (String)"keyRawSize must be non-negative: %s", (int)keyRawSize);
        Preconditions.checkState((this.valueWriters.size() < this.maxFlattenedMapKeyCount - 1 ? 1 : 0) != 0, (String)"Map column writer for node %s reached max allowed number of keys %s", (int)this.nodeIndex, (int)this.maxFlattenedMapKeyCount);
        int valueWriterIdx = this.valueWriters.size();
        int sequence = valueWriterIdx + 1;
        ColumnWriter columnWriter = this.valueWriterFactory.apply(sequence);
        MapFlatValueWriter valueWriter = new MapFlatValueWriter(this.valueNodeIndex, sequence, keyRawSize, dwrfKey, columnWriter, this.columnWriterOptions, this.dwrfEncryptor);
        this.valueWriters.add(valueWriter);
        this.growCapacity();
        valueWriter.writeNotInMap(this.rowsInFinishedRowGroups, this.nonNullRowGroupValueCount);
        this.valueWritersLastRow[valueWriterIdx] = this.nonNullRowGroupValueCount + 1;
        return valueWriter;
    }

    private void growCapacity() {
        if (this.valueWritersLastRow.length < this.valueWriters.size()) {
            this.valueWritersLastRow = Arrays.ensureCapacity((int[])this.valueWritersLastRow, (int)Math.max(16, this.valueWriters.size()), (Arrays.ExpansionFactor)Arrays.ExpansionFactor.MEDIUM, (Arrays.ExpansionOption)Arrays.ExpansionOption.PRESERVE);
        }
    }

    private static Block createNullValueBlock(Type valueType) {
        if (valueType instanceof FixedWidthType) {
            FixedWidthType fixedWidthType = (FixedWidthType)valueType;
            return fixedWidthType.createFixedSizeBlockBuilder(1).appendNull().build();
        }
        return valueType.createBlockBuilder(null, 1).appendNull().build();
    }

    private KeyManager getKeyManager(Type type, Supplier<StatisticsBuilder> statisticsBuilderSupplier) {
        if (type == BigintType.BIGINT || type == IntegerType.INTEGER || type == SmallintType.SMALLINT || type == TinyintType.TINYINT) {
            return new NumericKeyManager(statisticsBuilderSupplier, (FixedWidthType)type);
        }
        if (type instanceof VarcharType || type == VarbinaryType.VARBINARY) {
            return new SliceKeyManager(statisticsBuilderSupplier);
        }
        throw new IllegalArgumentException("Unsupported flat map key type: " + type);
    }

    private class SliceKeyManager
    extends KeyManager<Map<Slice, MapFlatValueWriter>> {
        public SliceKeyManager(Supplier<StatisticsBuilder> statisticsBuilderSupplier) {
            super(new HashMap(), statisticsBuilderSupplier);
        }

        @Override
        public MapFlatValueWriter getOrCreateValueWriter(int position, Block keyBlock) {
            Slice key = MapFlatColumnWriter.this.keyType.getSlice(keyBlock, position);
            this.rowGroupStatsBuilder.incrementRawSize(key.length());
            this.rowGroupStatsBuilder.addValue(MapFlatColumnWriter.this.keyType, keyBlock, position);
            MapFlatValueWriter valueWriter = (MapFlatValueWriter)this.keyToWriter.get(key);
            if (valueWriter == null) {
                if (!key.isCompact()) {
                    key = Slices.copyOf((Slice)key);
                }
                valueWriter = MapFlatColumnWriter.this.createNewValueWriter(this.createDwrfKey(key), key.length());
                this.keyToWriter.put(key, valueWriter);
            }
            return valueWriter;
        }

        private DwrfProto.KeyInfo createDwrfKey(Slice key) {
            DwrfProto.KeyInfo dwrfKey;
            int sliceLength = key.length();
            if (sliceLength == 0) {
                dwrfKey = EMPTY_SLICE_KEY;
            } else {
                ByteString byteString = ByteString.copyFrom((byte[])key.getBytes(), (int)0, (int)sliceLength);
                dwrfKey = DwrfProto.KeyInfo.newBuilder().setBytesKey(byteString).build();
            }
            return dwrfKey;
        }
    }

    private class NumericKeyManager
    extends KeyManager<Long2ObjectOpenHashMap<MapFlatValueWriter>> {
        private final int typeSize;

        public NumericKeyManager(Supplier<StatisticsBuilder> statisticsBuilderSupplier, FixedWidthType type) {
            super(new Long2ObjectOpenHashMap(), statisticsBuilderSupplier);
            Preconditions.checkArgument((type.getFixedSize() > 0 ? 1 : 0) != 0, (String)"Integer type size must for %s be positive: %s", (Object)type, (int)type.getFixedSize());
            this.typeSize = type.getFixedSize();
        }

        @Override
        public MapFlatValueWriter getOrCreateValueWriter(int position, Block keyBlock) {
            this.rowGroupStatsBuilder.incrementRawSize(this.typeSize);
            this.rowGroupStatsBuilder.addValue(MapFlatColumnWriter.this.keyType, keyBlock, position);
            long key = MapFlatColumnWriter.this.keyType.getLong(keyBlock, position);
            MapFlatValueWriter valueWriter = (MapFlatValueWriter)((Long2ObjectOpenHashMap)this.keyToWriter).get(key);
            if (valueWriter == null) {
                valueWriter = MapFlatColumnWriter.this.createNewValueWriter(this.createDwrfKey(key), this.typeSize);
                ((Long2ObjectOpenHashMap)this.keyToWriter).put(key, (Object)valueWriter);
            }
            return valueWriter;
        }

        private DwrfProto.KeyInfo createDwrfKey(long key) {
            return DwrfProto.KeyInfo.newBuilder().setIntKey(key).build();
        }
    }

    private static abstract class KeyManager<T extends Map<?, MapFlatValueWriter>> {
        protected StatisticsBuilder rowGroupStatsBuilder;
        protected final T keyToWriter;
        private final Supplier<StatisticsBuilder> statisticsBuilderSupplier;

        public KeyManager(T keyToWriter, Supplier<StatisticsBuilder> statisticsBuilderSupplier) {
            this.keyToWriter = (Map)Objects.requireNonNull(keyToWriter, "keyToWriter is null");
            this.statisticsBuilderSupplier = Objects.requireNonNull(statisticsBuilderSupplier, "statisticsBuilderSupplier is null");
            this.rowGroupStatsBuilder = statisticsBuilderSupplier.get();
        }

        public abstract MapFlatValueWriter getOrCreateValueWriter(int var1, Block var2);

        public ColumnStatistics getStripeColumnStatistics() {
            return this.rowGroupStatsBuilder.buildColumnStatistics();
        }

        public void reset() {
            this.keyToWriter.clear();
            this.rowGroupStatsBuilder = this.statisticsBuilderSupplier.get();
        }
    }
}

