/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.proto.DwrfProto;
import com.facebook.presto.orc.stream.InMapOutputStream;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class MapFlatValueWriter {
    private final int nodeIndex;
    private final int sequence;
    private final ColumnWriter valueWriter;
    private final DwrfProto.KeyInfo dwrfKey;
    private final InMapOutputStream inMapStream;
    private final int keyRawSize;

    public MapFlatValueWriter(int nodeIndex, int sequence, int keyRawSize, DwrfProto.KeyInfo dwrfKey, ColumnWriter valueWriter, ColumnWriterOptions columnWriterOptions, Optional<DwrfDataEncryptor> dwrfEncryptor) {
        Preconditions.checkArgument((nodeIndex > 0 ? 1 : 0) != 0, (String)"nodeIndex is invalid: %s", (int)nodeIndex);
        Preconditions.checkArgument((sequence > 0 ? 1 : 0) != 0, (String)"sequence must be positive: %s", (int)sequence);
        Preconditions.checkArgument((keyRawSize >= 0 ? 1 : 0) != 0, (String)"keyRawSize must be non-negative: %s", (int)keyRawSize);
        Objects.requireNonNull(columnWriterOptions, "columnWriterOptions is null");
        Objects.requireNonNull(dwrfEncryptor, "dwrfEncryptor is null");
        this.nodeIndex = nodeIndex;
        this.sequence = sequence;
        this.keyRawSize = keyRawSize;
        this.dwrfKey = Objects.requireNonNull(dwrfKey, "dwrfKey is null");
        this.valueWriter = Objects.requireNonNull(valueWriter, "valueWriter is null");
        this.inMapStream = new InMapOutputStream(columnWriterOptions, dwrfEncryptor);
    }

    public int getSequence() {
        return this.sequence;
    }

    public int getKeyRawSize() {
        return this.keyRawSize;
    }

    public ColumnWriter getValueWriter() {
        return this.valueWriter;
    }

    public DwrfProto.KeyInfo getDwrfKey() {
        return this.dwrfKey;
    }

    public void beginRowGroup() {
        this.inMapStream.recordCheckpoint();
        this.valueWriter.beginRowGroup();
    }

    public long writeSingleEntryBlock(Block block) {
        long size = this.valueWriter.writeBlock(block);
        this.inMapStream.writeBoolean(true);
        return size;
    }

    public long writeNotInMap(int count) {
        this.inMapStream.writeBooleans(count, false);
        return count;
    }

    public void writeNotInMap(IntList rowsInFinishedRowGroups, int rowsInCurrentRowGroup) {
        for (int i = 0; i < rowsInFinishedRowGroups.size(); ++i) {
            this.beginRowGroup();
            int rows = rowsInFinishedRowGroups.getInt(i);
            this.inMapStream.writeBooleans(rows, false);
            this.valueWriter.finishRowGroup();
        }
        this.beginRowGroup();
        if (rowsInCurrentRowGroup > 0) {
            this.inMapStream.writeBooleans(rowsInCurrentRowGroup, false);
        }
    }

    public List<StreamDataOutput> getDataStreams() {
        return ImmutableList.builder().add((Object)this.inMapStream.getStreamDataOutput(this.nodeIndex, this.sequence)).addAll(this.valueWriter.getDataStreams()).build();
    }

    public List<StreamDataOutput> getIndexStreams() throws IOException {
        return this.valueWriter.getIndexStreams(Optional.of(this.inMapStream.getCheckpoints()));
    }

    public long getBufferedBytes() {
        return this.valueWriter.getBufferedBytes() + this.inMapStream.getBufferedBytes();
    }

    public void close() {
        this.inMapStream.close();
        this.valueWriter.close();
    }
}

