/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.dictionary;

import com.facebook.presto.parquet.DictionaryPage;
import com.facebook.presto.parquet.dictionary.Dictionary;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.column.values.plain.PlainValuesReader;

public class IntegerDictionary
extends Dictionary {
    private final int[] content;

    public IntegerDictionary(DictionaryPage dictionaryPage) throws IOException {
        super(dictionaryPage.getEncoding());
        this.content = new int[dictionaryPage.getDictionarySize()];
        PlainValuesReader.IntegerPlainValuesReader intReader = new PlainValuesReader.IntegerPlainValuesReader();
        ByteBufferInputStream inputStream = ByteBufferInputStream.wrap((List)ImmutableList.of((Object)dictionaryPage.getSlice().toByteBuffer()));
        intReader.initFromPage(dictionaryPage.getDictionarySize(), inputStream);
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = intReader.readInteger();
        }
    }

    @Override
    public int decodeToInt(int id) {
        return this.content[id];
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("content", (Object)this.content).toString();
    }
}

