/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.reader;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.reader.PrimitiveColumnReader;
import org.apache.parquet.schema.PrimitiveType;

public class ShortDecimalColumnReader
extends PrimitiveColumnReader {
    ShortDecimalColumnReader(RichColumnDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type type) {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            long decimalValue = this.columnDescriptor.getPrimitiveType().getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.INT32) ? (long)this.valuesReader.readInteger() : (this.columnDescriptor.getPrimitiveType().getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.INT64) ? this.valuesReader.readLong() : ParquetTypeUtils.getShortDecimalValue(this.valuesReader.readBytes().getBytes()));
            type.writeLong(blockBuilder, decimalValue);
        } else if (this.isValueNull()) {
            blockBuilder.appendNull();
        }
    }

    @Override
    protected void skipValue() {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            if (this.columnDescriptor.getType().equals((Object)PrimitiveType.PrimitiveTypeName.INT32)) {
                this.valuesReader.readInteger();
            } else if (this.columnDescriptor.getType().equals((Object)PrimitiveType.PrimitiveTypeName.INT64)) {
                this.valuesReader.readLong();
            } else {
                this.valuesReader.readBytes();
            }
        }
    }
}

